/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.collect;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.Supplier;
import lombok.Generated;

public final class KiwiIterators {
    private static final String NOT_ENOUGH_VALUES_ERROR = "need at least 1 element to cycle";

    public static <T> Iterator<T> cycleForever(Iterable<T> iterable) {
        ImmutableList elements = ImmutableList.copyOf(iterable);
        Preconditions.checkArgument((!elements.isEmpty() ? 1 : 0) != 0, (Object)NOT_ENOUGH_VALUES_ERROR);
        return new ThreadSafeCyclicIterator(elements);
    }

    @SafeVarargs
    public static <T> Iterator<T> cycleForever(T ... elements) {
        Preconditions.checkArgument((elements.length > 0 ? 1 : 0) != 0, (Object)NOT_ENOUGH_VALUES_ERROR);
        return new ThreadSafeCyclicIterator(Lists.newArrayList((Object[])elements));
    }

    @Generated
    private KiwiIterators() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static class ThreadSafeCyclicIterator<E>
    implements Iterator<E> {
        private final Iterator<E> cycler;
        private final Lock cyclerLock;

        ThreadSafeCyclicIterator(Iterable<E> iterable) {
            this.cycler = Iterators.cycle(iterable);
            this.cyclerLock = new ReentrantLock();
        }

        @Override
        public boolean hasNext() {
            return this.withLock(this.cycler::hasNext);
        }

        @Override
        public E next() {
            return (E)this.withLock(() -> {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("there are no elements to cycle");
                }
                return this.cycler.next();
            });
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("unsupported; cannot remove from an infinite cycling iterator");
        }

        @Override
        public void forEachRemaining(Consumer<? super E> action) {
            throw new UnsupportedOperationException("unsupported; infinite loop would occur unless an exception is thrown");
        }

        private <T> T withLock(Supplier<T> supplier) {
            try {
                this.cyclerLock.lock();
                T t = supplier.get();
                return t;
            }
            finally {
                this.cyclerLock.unlock();
            }
        }
    }
}

