/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.concurrent;

import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import lombok.Generated;
import org.kiwiproject.base.KiwiPreconditions;
import org.kiwiproject.concurrent.Async;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncHelper {
    @Generated
    private static final Logger LOG = LoggerFactory.getLogger(AsyncHelper.class);
    private Async.Mode asyncMode = Async.Mode.ENABLED;

    public void setUnitTestAsyncMode(Async.Mode mode) {
        KiwiPreconditions.checkArgumentNotNull(mode, "mode cannot be null");
        Async.logWarningWhenAsyncDisabled(mode);
        this.asyncMode = mode;
    }

    public CompletableFuture<Void> runAsync(Runnable func) {
        return this.doAsync(func);
    }

    public CompletableFuture<Void> runAsync(Runnable func, Executor executor) {
        return this.doAsync(func, executor);
    }

    public CompletableFuture<Void> doAsync(Runnable func) {
        return this.doAsync(func, (Executor)ForkJoinPool.commonPool());
    }

    public CompletableFuture<Void> doAsync(Runnable func, Executor executor) {
        return Async.waitIfAsyncDisabled(CompletableFuture.runAsync(func, executor), this.asyncMode);
    }

    public <T> CompletableFuture<T> supplyAsync(Supplier<T> supplier) {
        return this.doAsync(supplier);
    }

    public <T> CompletableFuture<T> supplyAsync(Supplier<T> supplier, Executor executor) {
        return this.doAsync(supplier, executor);
    }

    public <T> CompletableFuture<T> doAsync(Supplier<T> supplier) {
        return this.doAsync(supplier, (Executor)ForkJoinPool.commonPool());
    }

    public <T> CompletableFuture<T> doAsync(Supplier<T> supplier, Executor executor) {
        return Async.waitIfAsyncDisabled(CompletableFuture.supplyAsync(supplier, executor), this.asyncMode);
    }

    public <T> void waitFor(CompletableFuture<T> future, long timeout, TimeUnit unit) {
        Async.waitFor(future, timeout, unit);
    }

    public <T> void waitForAll(Collection<CompletableFuture<T>> futures, long timeout, TimeUnit unit) {
        Async.waitForAll(futures, timeout, unit);
    }

    public void waitForAllIgnoringType(Collection<CompletableFuture> futures, long timeout, TimeUnit unit) {
        Async.waitForAllIgnoringType(futures, timeout, unit);
    }

    public <T> CompletableFuture<T> withMaxTimeout(CompletableFuture<T> future, long timeout, TimeUnit unit) {
        return this.withMaxTimeout(future, timeout, unit, ForkJoinPool.commonPool());
    }

    public <T> CompletableFuture<T> withMaxTimeout(CompletableFuture<T> future, long timeout, TimeUnit unit, ExecutorService executor) {
        return Async.withMaxTimeout(future, timeout, unit, executor);
    }
}

