/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.config;

import com.google.common.base.Preconditions;
import jakarta.ws.rs.core.UriBuilder;
import java.net.URI;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import org.apache.commons.lang3.math.NumberUtils;
import org.kiwiproject.base.KiwiStrings;
import org.kiwiproject.config.EndpointUriBuilder;
import org.kiwiproject.config.SecureEndpointsConfiguration;
import org.kiwiproject.config.UrlRewriteConfiguration;

public class EndpointConfiguration {
    private String tag;
    private String scheme;
    private String domain;
    private List<String> domainList;
    private String port;
    private String path;
    private UrlRewriteConfiguration urlRewriteConfiguration = UrlRewriteConfiguration.none();
    private AtomicInteger roundRobinIndex = new AtomicInteger(0);

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(SecureEndpointsConfiguration.Builder parent) {
        return new Builder(parent);
    }

    public boolean isSecure() {
        return "wss".equalsIgnoreCase(this.scheme) || "https".equalsIgnoreCase(this.scheme);
    }

    public void setDomain(String singleDomainOrCsv) {
        this.domain = singleDomainOrCsv;
        this.domainList = KiwiStrings.splitOnCommas(singleDomainOrCsv);
    }

    public List<String> getDomains() {
        return this.domainList;
    }

    public String getURI() {
        return this.getUriWithNextHost(this.path);
    }

    public URI getUriObject() {
        return URI.create(this.getURI());
    }

    private String getUriWithNextHost(String thePath) {
        String nextHost = this.getNextDomain();
        return EndpointUriBuilder.builder().scheme(this.scheme).host(nextHost).port(this.port).path(thePath).urlRewriteConfig(this.urlRewriteConfiguration).build().getURI();
    }

    private synchronized String getNextDomain() {
        Preconditions.checkState((boolean)Objects.nonNull(this.domainList), (Object)"No domains have been set on this endpoint!");
        if (this.domainList.size() == 1) {
            return this.domain;
        }
        String nextDomain = this.domainList.get(this.roundRobinIndex.getAndIncrement());
        if (this.roundRobinIndex.get() >= this.domainList.size()) {
            this.roundRobinIndex.set(0);
        }
        return nextDomain;
    }

    public UriBuilder toUriBuilder() {
        return UriBuilder.fromUri((String)this.getURI());
    }

    @Generated
    public String getTag() {
        return this.tag;
    }

    @Generated
    public String getScheme() {
        return this.scheme;
    }

    @Generated
    public String getDomain() {
        return this.domain;
    }

    @Generated
    public String getPort() {
        return this.port;
    }

    @Generated
    public String getPath() {
        return this.path;
    }

    @Generated
    public UrlRewriteConfiguration getUrlRewriteConfiguration() {
        return this.urlRewriteConfiguration;
    }

    @Generated
    public void setTag(String tag) {
        this.tag = tag;
    }

    @Generated
    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    @Generated
    public void setPort(String port) {
        this.port = port;
    }

    @Generated
    public void setPath(String path) {
        this.path = path;
    }

    @Generated
    public void setUrlRewriteConfiguration(UrlRewriteConfiguration urlRewriteConfiguration) {
        this.urlRewriteConfiguration = urlRewriteConfiguration;
    }

    public static class Builder {
        private final EndpointConfiguration endpoint = new EndpointConfiguration();
        private SecureEndpointsConfiguration.Builder parent;

        protected Builder(SecureEndpointsConfiguration.Builder parent) {
            this.parent = parent;
        }

        public Builder tag(String tag) {
            return this.setTag(tag);
        }

        public Builder setTag(String tag) {
            this.endpoint.setTag(tag);
            return this;
        }

        public Builder scheme(String scheme) {
            return this.setScheme(scheme);
        }

        public Builder setScheme(String scheme) {
            this.endpoint.setScheme(scheme);
            return this;
        }

        public Builder domain(String domain) {
            return this.setDomain(domain);
        }

        public Builder setDomain(String domain) {
            this.endpoint.setDomain(EndpointUriBuilder.stripLeadingAndTrailingSlashes(domain));
            return this;
        }

        public Builder port(String port) {
            return this.setPort(port);
        }

        public Builder setPort(String port) {
            Preconditions.checkArgument((boolean)NumberUtils.isDigits((String)port), (String)"port should contain only digits: %s", (Object)port);
            this.endpoint.setPort(port);
            return this;
        }

        public Builder path(String path) {
            return this.setPath(path);
        }

        public Builder setPath(String path) {
            this.endpoint.setPath(path);
            return this;
        }

        public Builder urlRewriteConfiguration(UrlRewriteConfiguration urlRewriteConfig) {
            return this.setUrlRewriteConfiguration(urlRewriteConfig);
        }

        public Builder setUrlRewriteConfiguration(UrlRewriteConfiguration urlRewriteConfig) {
            this.endpoint.setUrlRewriteConfiguration(urlRewriteConfig);
            return this;
        }

        public EndpointConfiguration build() {
            return this.endpoint;
        }

        public SecureEndpointsConfiguration.Builder buildEndpoint() {
            Preconditions.checkState((boolean)Objects.nonNull(this.parent), (Object)"The parent SecureEndpointsConfiguration is null. This method should only be used when building via SecureEndpointsConfiguration.");
            this.parent.build().getEndpoints().add(this.endpoint);
            return this.parent;
        }

        @Generated
        Builder() {
        }
    }
}

