/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.dropwizard.config;

import com.codahale.metrics.health.HealthCheck;
import com.google.common.base.CaseFormat;
import io.dropwizard.core.setup.Environment;
import io.dropwizard.util.Duration;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.kiwiproject.base.KiwiStrings;
import org.kiwiproject.dropwizard.metrics.health.TimeBasedDirectoryCleanerHealthCheck;
import org.kiwiproject.io.TimeBasedDirectoryCleaner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class TimeBasedDirectoryCleanerConfig {
    @Generated
    private static final Logger LOG = LoggerFactory.getLogger(TimeBasedDirectoryCleanerConfig.class);
    public static final Duration DEFAULT_INITIAL_DELAY_MILLIS = Duration.seconds((long)1L);
    public static final Duration SHUTDOWN_DURATION = Duration.seconds((long)10L);
    @NotBlank
    private String directoryPath;
    @NotNull
    private Duration retentionThreshold;
    @NotNull
    private Duration initialCleanupDelay = DEFAULT_INITIAL_DELAY_MILLIS;
    @NotNull
    private Duration cleanupInterval;
    @NotNull
    private Duration healthCheckWarningDuration = Duration.hours((long)1L);
    @NotBlank
    private String deleteErrorLogLevel = Level.WARN.toString();

    public TimeBasedDirectoryCleaner scheduleCleanupUsing(ScheduledExecutorService cleanupExecutor) {
        long intervalMillis = this.cleanupInterval.toMilliseconds();
        TimeBasedDirectoryCleaner cleaner = TimeBasedDirectoryCleaner.builder().directoryPath(this.directoryPath).retentionThreshold(this.retentionThreshold.toJavaDuration()).deleteErrorLogLevel(this.deleteErrorLogLevel).build();
        cleanupExecutor.scheduleWithFixedDelay(cleaner, this.initialCleanupDelay.toMilliseconds(), intervalMillis, TimeUnit.MILLISECONDS);
        LOG.info("Scheduled cleanup of {} with retention threshold {}; initial delay {}; interval {}", new Object[]{this.directoryPath, this.retentionThreshold, this.initialCleanupDelay, this.cleanupInterval});
        return cleaner;
    }

    public TimeBasedDirectoryCleaner scheduleCleanupUsing(Environment environment) {
        ScheduledExecutorService cleanupExecutor = environment.lifecycle().scheduledExecutorService(TimeBasedDirectoryCleanerConfig.nameFormatFor(this.directoryPath), true).threads(1).shutdownTime(SHUTDOWN_DURATION).build();
        TimeBasedDirectoryCleaner cleaner = this.scheduleCleanupUsing(cleanupExecutor);
        environment.healthChecks().register(KiwiStrings.format("{}({})", TimeBasedDirectoryCleanerConfig.lowerCamelCaseCleanerClassName(), this.directoryPath), (HealthCheck)new TimeBasedDirectoryCleanerHealthCheck(cleaner, this.healthCheckWarningDuration.toJavaDuration()));
        LOG.info("Registered health check for {} directory cleaner with warning duration {}", (Object)this.directoryPath, (Object)this.healthCheckWarningDuration);
        return cleaner;
    }

    private static String nameFormatFor(String directoryPath) {
        return KiwiStrings.format("{}({})-%d", TimeBasedDirectoryCleanerConfig.lowerCamelCaseCleanerClassName(), directoryPath);
    }

    private static String lowerCamelCaseCleanerClassName() {
        String simpleName = TimeBasedDirectoryCleaner.class.getSimpleName();
        return (String)CaseFormat.UPPER_CAMEL.converterTo(CaseFormat.LOWER_CAMEL).convert((Object)simpleName);
    }

    @Generated
    public String getDirectoryPath() {
        return this.directoryPath;
    }

    @Generated
    public Duration getRetentionThreshold() {
        return this.retentionThreshold;
    }

    @Generated
    public Duration getInitialCleanupDelay() {
        return this.initialCleanupDelay;
    }

    @Generated
    public Duration getCleanupInterval() {
        return this.cleanupInterval;
    }

    @Generated
    public Duration getHealthCheckWarningDuration() {
        return this.healthCheckWarningDuration;
    }

    @Generated
    public String getDeleteErrorLogLevel() {
        return this.deleteErrorLogLevel;
    }

    @Generated
    public void setDirectoryPath(String directoryPath) {
        this.directoryPath = directoryPath;
    }

    @Generated
    public void setRetentionThreshold(Duration retentionThreshold) {
        this.retentionThreshold = retentionThreshold;
    }

    @Generated
    public void setInitialCleanupDelay(Duration initialCleanupDelay) {
        this.initialCleanupDelay = initialCleanupDelay;
    }

    @Generated
    public void setCleanupInterval(Duration cleanupInterval) {
        this.cleanupInterval = cleanupInterval;
    }

    @Generated
    public void setHealthCheckWarningDuration(Duration healthCheckWarningDuration) {
        this.healthCheckWarningDuration = healthCheckWarningDuration;
    }

    @Generated
    public void setDeleteErrorLogLevel(String deleteErrorLogLevel) {
        this.deleteErrorLogLevel = deleteErrorLogLevel;
    }
}

