/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.jaxrs;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.jspecify.annotations.NonNull;
import org.kiwiproject.base.KiwiPreconditions;
import org.kiwiproject.base.KiwiStrings;
import org.kiwiproject.collect.KiwiLists;
import org.kiwiproject.jaxrs.KiwiJaxrsValidations;
import org.kiwiproject.jaxrs.exception.JaxrsBadRequestException;
import org.kiwiproject.jaxrs.exception.JaxrsNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KiwiResources {
    @Generated
    private static final Logger LOG = LoggerFactory.getLogger(KiwiResources.class);
    private static final Map<String, Object> EMPTY_HEADERS = Map.of();
    private static final String PARAMETERS_MUST_NOT_BE_NULL = "parameters must not be null";
    private static final String PARAMETER_NAME_MUST_NOT_BE_BLANK = "parameterName must not be blank";

    public static <T> void verifyExistence(T resourceEntity) {
        KiwiResources.verifyExistence(resourceEntity, null);
    }

    public static <T> @NonNull T verifyExistenceAndReturn(T resourceEntity) {
        return KiwiResources.verifyExistence(Optional.ofNullable(resourceEntity));
    }

    public static <T> @NonNull T verifyExistence(Optional<T> resourceEntity) {
        KiwiResources.verifyExistence(resourceEntity.orElse(null), null);
        return resourceEntity.orElseThrow();
    }

    public static <T> void verifyExistence(T resourceEntity, Class<T> entityType, Object identifier) {
        String notFoundMessage = JaxrsNotFoundException.buildMessage(entityType.getSimpleName(), identifier);
        KiwiResources.verifyExistence(resourceEntity, notFoundMessage);
    }

    public static <T> @NonNull T verifyExistenceAndReturn(T resourceEntity, Class<T> entityType, Object identifier) {
        return KiwiResources.verifyExistence(Optional.ofNullable(resourceEntity), entityType, identifier);
    }

    public static <T> @NonNull T verifyExistence(Optional<T> resourceEntity, Class<T> entityType, Object identifier) {
        String notFoundMessage = JaxrsNotFoundException.buildMessage(entityType.getSimpleName(), identifier);
        KiwiResources.verifyExistence(resourceEntity.orElse(null), notFoundMessage);
        return resourceEntity.orElseThrow();
    }

    public static <T> void verifyExistence(T resourceEntity, String notFoundMessage) {
        if (Objects.isNull(resourceEntity)) {
            throw new JaxrsNotFoundException(notFoundMessage);
        }
    }

    public static <T> @NonNull T verifyExistenceAndReturn(T resourceEntity, String notFoundMessage) {
        return KiwiResources.verifyExistence(Optional.ofNullable(resourceEntity), notFoundMessage);
    }

    public static <T> @NonNull T verifyExistence(Optional<T> resourceEntity, String notFoundMessage) {
        KiwiResources.verifyExistence(resourceEntity.orElse(null), notFoundMessage);
        return resourceEntity.orElseThrow();
    }

    public static <T> void verifyExistence(T resourceEntity, String notFoundMessageTemplate, Object ... args) {
        if (Objects.isNull(resourceEntity)) {
            String message = KiwiStrings.f(notFoundMessageTemplate, args);
            throw new JaxrsNotFoundException(message);
        }
    }

    public static <T> @NonNull T verifyExistenceAndReturn(T resourceEntity, String notFoundMessageTemplate, Object ... args) {
        return KiwiResources.verifyExistence(Optional.ofNullable(resourceEntity), notFoundMessageTemplate, args);
    }

    public static <T> @NonNull T verifyExistence(Optional<T> resourceEntity, String notFoundMessageTemplate, Object ... args) {
        KiwiResources.verifyExistence(resourceEntity.orElse(null), notFoundMessageTemplate, args);
        return resourceEntity.orElseThrow();
    }

    public static Response newResponse(Response.Status status, Object entity) {
        return KiwiResources.newResponseBuilder(status, entity).build();
    }

    public static Response.ResponseBuilder newResponseBuilder(Response.Status status, Object entity) {
        return KiwiResources.newResponseBuilder(status, entity, EMPTY_HEADERS);
    }

    public static Response newResponse(Response.Status status, Object entity, String contentType) {
        return KiwiResources.newResponseBuilder(status, entity, contentType).build();
    }

    public static Response.ResponseBuilder newResponseBuilder(Response.Status status, Object entity, String contentType) {
        return KiwiResources.newResponseBuilder(status, entity).type(contentType);
    }

    public static Response newResponse(Response.Status status, Object entity, Map<String, Object> singleValuedHeaders) {
        return KiwiResources.newResponseBuilder(status, entity, singleValuedHeaders).build();
    }

    public static Response.ResponseBuilder newResponseBuilder(Response.Status status, Object entity, Map<String, Object> singleValuedHeaders) {
        Response.ResponseBuilder responseBuilder = Response.status((Response.Status)status).entity(entity);
        singleValuedHeaders.forEach((arg_0, arg_1) -> ((Response.ResponseBuilder)responseBuilder).header(arg_0, arg_1));
        return responseBuilder;
    }

    public static Response newResponse(Response.Status status, Object entity, MultivaluedMap<String, Object> headers) {
        return KiwiResources.newResponseBuilder(status, entity, headers).build();
    }

    public static Response.ResponseBuilder newResponseBuilder(Response.Status status, Object entity, MultivaluedMap<String, Object> headers) {
        Response.ResponseBuilder responseBuilder = Response.status((Response.Status)status).entity(entity);
        headers.forEach((name, values) -> values.forEach(value -> responseBuilder.header(name, value)));
        return responseBuilder;
    }

    public static Response createdResponse(URI location, Object entity) {
        return KiwiResources.createdResponseBuilder(location, entity).build();
    }

    public static Response.ResponseBuilder createdResponseBuilder(URI location, Object entity) {
        return Response.created((URI)location).entity(entity);
    }

    public static Response okResponse(Object entity) {
        return KiwiResources.okResponseBuilder(entity).build();
    }

    public static Response.ResponseBuilder okResponseBuilder(Object entity) {
        return Response.ok((Object)entity);
    }

    public static Response newResponseBufferingEntityFrom(Response originalResponse) {
        return KiwiResources.newResponseBuilderBufferingEntityFrom(originalResponse).build();
    }

    public static Response.ResponseBuilder newResponseBuilderBufferingEntityFrom(Response originalResponse) {
        boolean wasBuffered = originalResponse.bufferEntity();
        if (!wasBuffered) {
            LOG.warn("Attempt to buffer entity in original response returned false; possible causes: it was not backed by an unconsumed input stream; the input stream was already consumed; or, it did not have an entity");
        }
        return Response.fromResponse((Response)originalResponse);
    }

    public static <V> int validateIntParameter(Map<String, V> parameters, String parameterName) {
        KiwiPreconditions.checkArgumentNotNull(parameters, PARAMETERS_MUST_NOT_BE_NULL);
        KiwiPreconditions.checkArgumentNotBlank(parameterName, PARAMETER_NAME_MUST_NOT_BE_BLANK);
        V value = parameters.get(parameterName);
        KiwiJaxrsValidations.assertNotNull(parameterName, value);
        return KiwiResources.parseIntOrThrowBadRequest(value, parameterName);
    }

    public static <V> int validateOneIntParameter(MultivaluedMap<String, V> parameters, String parameterName) {
        KiwiPreconditions.checkArgumentNotNull(parameters, PARAMETERS_MUST_NOT_BE_NULL);
        KiwiPreconditions.checkArgumentNotBlank(parameterName, PARAMETER_NAME_MUST_NOT_BE_BLANK);
        Object value = parameters.getFirst((Object)parameterName);
        KiwiJaxrsValidations.assertNotNull(parameterName, value);
        return KiwiResources.parseIntOrThrowBadRequest(value, parameterName);
    }

    public static <V> int validateExactlyOneIntParameter(MultivaluedMap<String, V> parameters, String parameterName) {
        KiwiPreconditions.checkArgumentNotNull(parameters, PARAMETERS_MUST_NOT_BE_NULL);
        KiwiPreconditions.checkArgumentNotBlank(parameterName, PARAMETER_NAME_MUST_NOT_BE_BLANK);
        List values = (List)parameters.get((Object)parameterName);
        KiwiResources.assertOneElementOrThrowBadRequest(values, parameterName);
        Object value = KiwiLists.first(values);
        return KiwiResources.parseIntOrThrowBadRequest(value, parameterName);
    }

    public static <V> List<Integer> validateOneOrMoreIntParameters(MultivaluedMap<String, V> parameters, String parameterName) {
        KiwiPreconditions.checkArgumentNotNull(parameters, PARAMETERS_MUST_NOT_BE_NULL);
        KiwiPreconditions.checkArgumentNotBlank(parameterName, PARAMETER_NAME_MUST_NOT_BE_BLANK);
        List values = (List)parameters.get((Object)parameterName);
        KiwiResources.assertOneOrMoreElementsOrThrowBadRequest(values, parameterName);
        return values.stream().map(value -> KiwiResources.parseIntOrThrowBadRequest(value, parameterName)).toList();
    }

    @VisibleForTesting
    static int parseIntOrThrowBadRequest(Object value, String parameterName) {
        Optional<Integer> result = Optional.ofNullable(value).map(Object::toString).map(Ints::tryParse);
        return result.orElseThrow(() -> KiwiResources.newJaxrsBadRequestException("'{}' is not an integer", value, parameterName));
    }

    public static <V> long validateLongParameter(Map<String, V> parameters, String parameterName) {
        KiwiPreconditions.checkArgumentNotNull(parameters, PARAMETERS_MUST_NOT_BE_NULL);
        KiwiPreconditions.checkArgumentNotBlank(parameterName, PARAMETER_NAME_MUST_NOT_BE_BLANK);
        V value = parameters.get(parameterName);
        KiwiJaxrsValidations.assertNotNull(parameterName, value);
        return KiwiResources.parseLongOrThrowBadRequest(value, parameterName);
    }

    public static <V> long validateOneLongParameter(MultivaluedMap<String, V> parameters, String parameterName) {
        KiwiPreconditions.checkArgumentNotNull(parameters, PARAMETERS_MUST_NOT_BE_NULL);
        KiwiPreconditions.checkArgumentNotBlank(parameterName, PARAMETER_NAME_MUST_NOT_BE_BLANK);
        Object value = parameters.getFirst((Object)parameterName);
        KiwiJaxrsValidations.assertNotNull(parameterName, value);
        return KiwiResources.parseLongOrThrowBadRequest(value, parameterName);
    }

    public static <V> long validateExactlyOneLongParameter(MultivaluedMap<String, V> parameters, String parameterName) {
        KiwiPreconditions.checkArgumentNotNull(parameters, PARAMETERS_MUST_NOT_BE_NULL);
        KiwiPreconditions.checkArgumentNotBlank(parameterName, PARAMETER_NAME_MUST_NOT_BE_BLANK);
        List values = (List)parameters.get((Object)parameterName);
        KiwiResources.assertOneElementOrThrowBadRequest(values, parameterName);
        Object value = KiwiLists.first(values);
        return KiwiResources.parseLongOrThrowBadRequest(value, parameterName);
    }

    public static <V> List<Long> validateOneOrMoreLongParameters(MultivaluedMap<String, V> parameters, String parameterName) {
        KiwiPreconditions.checkArgumentNotNull(parameters, PARAMETERS_MUST_NOT_BE_NULL);
        KiwiPreconditions.checkArgumentNotBlank(parameterName, PARAMETER_NAME_MUST_NOT_BE_BLANK);
        List values = (List)parameters.get((Object)parameterName);
        KiwiResources.assertOneOrMoreElementsOrThrowBadRequest(values, parameterName);
        return values.stream().map(value -> KiwiResources.parseLongOrThrowBadRequest(value, parameterName)).toList();
    }

    @VisibleForTesting
    static long parseLongOrThrowBadRequest(Object value, String parameterName) {
        Optional<Long> result = Optional.ofNullable(value).map(Object::toString).map(Longs::tryParse);
        return result.orElseThrow(() -> KiwiResources.newJaxrsBadRequestException("'{}' is not a long", value, parameterName));
    }

    @VisibleForTesting
    static <V> void assertOneElementOrThrowBadRequest(List<V> values, String parameterName) {
        String message = null;
        if (KiwiLists.isNullOrEmpty(values)) {
            message = parameterName + " has no values, but exactly one was expected";
        } else if (values.size() > 1) {
            message = parameterName + " has " + values.size() + " values, but only one was expected";
        }
        if (Objects.nonNull(message)) {
            throw new JaxrsBadRequestException(message, parameterName);
        }
    }

    @VisibleForTesting
    static <V> void assertOneOrMoreElementsOrThrowBadRequest(List<V> values, String parameterName) {
        if (KiwiLists.isNullOrEmpty(values)) {
            String message = parameterName + " has no values, but expected at least one";
            throw new JaxrsBadRequestException(message, parameterName);
        }
    }

    @VisibleForTesting
    static JaxrsBadRequestException newJaxrsBadRequestException(String messageTemplate, Object value, String parameterName) {
        String message = KiwiStrings.f(messageTemplate, value);
        return new JaxrsBadRequestException(message, parameterName);
    }

    @Generated
    private KiwiResources() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

