/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.jaxrs;

import com.google.common.annotations.VisibleForTesting;
import jakarta.ws.rs.core.Response;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import lombok.Generated;
import org.kiwiproject.base.KiwiPreconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KiwiResponses {
    @Generated
    private static final Logger LOG = LoggerFactory.getLogger(KiwiResponses.class);
    private static final Consumer<Response> NO_OP_RESPONSE_CONSUMER = new NoOpResponseConsumer();

    public static Optional<String> mediaType(Response response) {
        KiwiPreconditions.checkArgumentNotNull(response);
        return Optional.ofNullable(response.getMediaType()).map(Object::toString);
    }

    public static boolean successful(Response response) {
        return KiwiResponses.successful(response.getStatus());
    }

    public static boolean notSuccessful(Response response) {
        return KiwiResponses.notSuccessful(response.getStatus());
    }

    public static boolean successful(Response.Status status) {
        return KiwiResponses.successful(status.getStatusCode());
    }

    public static boolean notSuccessful(Response.Status status) {
        return KiwiResponses.notSuccessful(status.getStatusCode());
    }

    public static boolean successful(Response.StatusType status) {
        return KiwiResponses.successful(status.getStatusCode());
    }

    public static boolean notSuccessful(Response.StatusType status) {
        return KiwiResponses.notSuccessful(status.getStatusCode());
    }

    public static boolean successful(int statusCode) {
        return KiwiResponses.successful(Response.Status.Family.familyOf((int)statusCode));
    }

    public static boolean notSuccessful(int statusCode) {
        return !KiwiResponses.successful(statusCode);
    }

    public static boolean successful(Response.Status.Family family) {
        return family == Response.Status.Family.SUCCESSFUL;
    }

    public static boolean notSuccessful(Response.Status.Family family) {
        return !KiwiResponses.successful(family);
    }

    public static boolean successfulAlwaysClosing(Response response) {
        KiwiPreconditions.checkArgumentNotNull(response, "response cannot be null");
        try {
            boolean bl = KiwiResponses.successful(response);
            return bl;
        }
        finally {
            KiwiResponses.closeQuietly(response);
        }
    }

    public static boolean notSuccessfulAlwaysClosing(Response response) {
        return !KiwiResponses.successfulAlwaysClosing(response);
    }

    public static boolean ok(Response response) {
        return KiwiResponses.hasStatus(response, Response.Status.OK);
    }

    public static boolean created(Response response) {
        return KiwiResponses.hasStatus(response, Response.Status.CREATED);
    }

    public static boolean notFound(Response response) {
        return KiwiResponses.hasStatus(response, Response.Status.NOT_FOUND);
    }

    public static boolean internalServerError(Response response) {
        return KiwiResponses.hasStatus(response, Response.Status.INTERNAL_SERVER_ERROR);
    }

    public static boolean hasStatus(Response response, Response.Status status) {
        KiwiPreconditions.checkArgumentNotNull(response);
        KiwiPreconditions.checkArgumentNotNull(status);
        return response.getStatusInfo().getStatusCode() == status.getStatusCode();
    }

    public static boolean informational(Response response) {
        return KiwiResponses.hasFamily(response, Response.Status.Family.INFORMATIONAL);
    }

    public static boolean redirection(Response response) {
        return KiwiResponses.hasFamily(response, Response.Status.Family.REDIRECTION);
    }

    public static boolean clientError(Response response) {
        return KiwiResponses.hasFamily(response, Response.Status.Family.CLIENT_ERROR);
    }

    public static boolean serverError(Response response) {
        return KiwiResponses.hasFamily(response, Response.Status.Family.SERVER_ERROR);
    }

    public static boolean otherFamily(Response response) {
        return KiwiResponses.hasFamily(response, Response.Status.Family.OTHER);
    }

    public static boolean hasFamily(Response response, Response.Status.Family family) {
        KiwiPreconditions.checkArgumentNotNull(response);
        KiwiPreconditions.checkArgumentNotNull(family);
        return response.getStatusInfo().getFamily() == family;
    }

    public static void onSuccessOrFailure(Supplier<Response> responseSupplier, Consumer<Response> successConsumer, Consumer<Response> failureConsumer, Consumer<RuntimeException> exceptionConsumer) {
        KiwiPreconditions.checkArgumentNotNull(responseSupplier);
        KiwiPreconditions.checkArgumentNotNull(exceptionConsumer);
        WebCallResult result = KiwiResponses.getResponse(responseSupplier);
        if (result.hasResponse()) {
            KiwiResponses.onSuccessOrFailure(result.response(), successConsumer, failureConsumer);
        } else {
            exceptionConsumer.accept(result.error());
        }
    }

    public static void onSuccessOrFailure(Response response, Consumer<Response> successConsumer, Consumer<Response> failureConsumer) {
        KiwiPreconditions.checkArgumentNotNull(response);
        KiwiPreconditions.checkArgumentNotNull(successConsumer);
        KiwiPreconditions.checkArgumentNotNull(failureConsumer);
        try {
            if (KiwiResponses.successful(response)) {
                successConsumer.accept(response);
            } else {
                failureConsumer.accept(response);
            }
        }
        finally {
            KiwiResponses.closeQuietly(response);
        }
    }

    public static void onSuccessOrFailureThrow(Supplier<Response> responseSupplier, Consumer<Response> successConsumer, Function<Response, ? extends RuntimeException> throwingFun) {
        KiwiPreconditions.checkArgumentNotNull(responseSupplier);
        WebCallResult result = KiwiResponses.getResponse(responseSupplier);
        if (!result.hasResponse()) {
            throw result.error();
        }
        KiwiResponses.onSuccessOrFailureThrow(responseSupplier.get(), successConsumer, throwingFun);
    }

    public static void onSuccessOrFailureThrow(Response response, Consumer<Response> successConsumer, Function<Response, ? extends RuntimeException> throwingFun) {
        block4: {
            KiwiPreconditions.checkArgumentNotNull(response);
            KiwiPreconditions.checkArgumentNotNull(successConsumer);
            KiwiPreconditions.checkArgumentNotNull(throwingFun);
            try {
                if (KiwiResponses.successful(response)) {
                    successConsumer.accept(response);
                    break block4;
                }
                throw throwingFun.apply(response);
            }
            finally {
                KiwiResponses.closeQuietly(response);
            }
        }
    }

    public static void onSuccess(Supplier<Response> responseSupplier, Consumer<Response> successConsumer) {
        KiwiPreconditions.checkArgumentNotNull(responseSupplier);
        WebCallResult result = KiwiResponses.getResponse(responseSupplier);
        if (result.hasResponse()) {
            KiwiResponses.onSuccess(result.response(), successConsumer);
        }
    }

    public static void onSuccess(Response response, Consumer<Response> successConsumer) {
        KiwiResponses.onSuccessOrFailure(response, successConsumer, NO_OP_RESPONSE_CONSUMER);
    }

    public static <T> Optional<T> onSuccessWithResult(Supplier<Response> responseSupplier, Function<Response, T> successFun) {
        KiwiPreconditions.checkArgumentNotNull(responseSupplier);
        WebCallResult result = KiwiResponses.getResponse(responseSupplier);
        if (result.hasResponse()) {
            return KiwiResponses.onSuccessWithResult(result.response(), successFun);
        }
        return Optional.empty();
    }

    public static <T> Optional<T> onSuccessWithResult(Response response, Function<Response, T> successFun) {
        return KiwiResponses.onSuccessWithResultOrFailure(response, successFun, NO_OP_RESPONSE_CONSUMER);
    }

    public static void onFailure(Supplier<Response> responseSupplier, Consumer<Response> failureConsumer, Consumer<RuntimeException> exceptionConsumer) {
        KiwiPreconditions.checkArgumentNotNull(responseSupplier);
        KiwiPreconditions.checkArgumentNotNull(exceptionConsumer);
        WebCallResult result = KiwiResponses.getResponse(responseSupplier);
        if (result.hasResponse()) {
            KiwiResponses.onFailure(result.response(), failureConsumer);
        } else {
            exceptionConsumer.accept(result.error());
        }
    }

    public static void onFailure(Response response, Consumer<Response> failureConsumer) {
        KiwiResponses.onSuccessOrFailure(response, NO_OP_RESPONSE_CONSUMER, failureConsumer);
    }

    public static void onFailureThrow(Supplier<Response> responseSupplier, Function<Response, ? extends RuntimeException> throwingFun) {
        KiwiPreconditions.checkArgumentNotNull(responseSupplier);
        WebCallResult result = KiwiResponses.getResponse(responseSupplier);
        if (!result.hasResponse()) {
            throw result.error();
        }
        KiwiResponses.onFailureThrow(result.response(), throwingFun);
    }

    public static void onFailureThrow(Response response, Function<Response, ? extends RuntimeException> throwingFun) {
        KiwiPreconditions.checkArgumentNotNull(response);
        KiwiPreconditions.checkArgumentNotNull(throwingFun);
        try {
            if (KiwiResponses.notSuccessful(response)) {
                throw throwingFun.apply(response);
            }
        }
        finally {
            KiwiResponses.closeQuietly(response);
        }
    }

    public static <T> Optional<T> onSuccessWithResultOrFailure(Supplier<Response> responseSupplier, Function<Response, T> successFun, Consumer<Response> failureConsumer, Consumer<RuntimeException> exceptionConsumer) {
        KiwiPreconditions.checkArgumentNotNull(responseSupplier);
        KiwiPreconditions.checkArgumentNotNull(exceptionConsumer);
        WebCallResult result = KiwiResponses.getResponse(responseSupplier);
        if (result.hasResponse()) {
            return KiwiResponses.onSuccessWithResultOrFailure(result.response(), successFun, failureConsumer);
        }
        exceptionConsumer.accept(result.error());
        return Optional.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> Optional<T> onSuccessWithResultOrFailure(Response response, Function<Response, T> successFun, Consumer<Response> failureConsumer) {
        KiwiPreconditions.checkArgumentNotNull(response);
        KiwiPreconditions.checkArgumentNotNull(successFun);
        KiwiPreconditions.checkArgumentNotNull(failureConsumer);
        Object result = null;
        try {
            if (KiwiResponses.successful(response)) {
                result = successFun.apply(response);
            } else {
                failureConsumer.accept(response);
            }
        }
        finally {
            KiwiResponses.closeQuietly(response);
        }
        return Optional.ofNullable(result);
    }

    public static <T> T onSuccessOrFailureWithResult(Supplier<Response> responseSupplier, Function<Response, T> successFun, Function<Response, T> failedFun, Function<RuntimeException, T> exceptionFun) {
        KiwiPreconditions.checkArgumentNotNull(responseSupplier);
        KiwiPreconditions.checkArgumentNotNull(exceptionFun);
        WebCallResult result = KiwiResponses.getResponse(responseSupplier);
        if (result.hasResponse()) {
            return KiwiResponses.onSuccessOrFailureWithResult(result.response(), successFun, failedFun);
        }
        return exceptionFun.apply(result.error());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T onSuccessOrFailureWithResult(Response response, Function<Response, T> successFun, Function<Response, T> failedFun) {
        KiwiPreconditions.checkArgumentNotNull(response);
        KiwiPreconditions.checkArgumentNotNull(successFun);
        KiwiPreconditions.checkArgumentNotNull(failedFun);
        try {
            T t = KiwiResponses.successful(response) ? successFun.apply(response) : failedFun.apply(response);
            return t;
        }
        finally {
            KiwiResponses.closeQuietly(response);
        }
    }

    public static <T> T onSuccessWithResultOrFailureThrow(Supplier<Response> responseSupplier, Function<Response, T> successFun, Function<Response, ? extends RuntimeException> throwingFun) {
        KiwiPreconditions.checkArgumentNotNull(responseSupplier);
        WebCallResult result = KiwiResponses.getResponse(responseSupplier);
        if (result.hasResponse()) {
            return KiwiResponses.onSuccessWithResultOrFailureThrow(result.response(), successFun, throwingFun);
        }
        throw result.error();
    }

    public static <T> T onSuccessWithResultOrFailureThrow(Response response, Function<Response, T> successFun, Function<Response, ? extends RuntimeException> throwingFun) {
        KiwiPreconditions.checkArgumentNotNull(response);
        KiwiPreconditions.checkArgumentNotNull(successFun);
        KiwiPreconditions.checkArgumentNotNull(throwingFun);
        try {
            if (KiwiResponses.successful(response)) {
                T t = successFun.apply(response);
                return t;
            }
            throw throwingFun.apply(response);
        }
        finally {
            KiwiResponses.closeQuietly(response);
        }
    }

    public static void accept(Supplier<Response> responseSupplier, Consumer<Response> responseConsumer, Consumer<RuntimeException> exceptionConsumer) {
        KiwiPreconditions.checkArgumentNotNull(responseSupplier);
        KiwiPreconditions.checkArgumentNotNull(exceptionConsumer);
        WebCallResult result = KiwiResponses.getResponse(responseSupplier);
        if (result.hasResponse()) {
            KiwiResponses.accept(result.response(), responseConsumer);
        } else {
            exceptionConsumer.accept(result.error());
        }
    }

    public static void accept(Response response, Consumer<Response> responseConsumer) {
        KiwiPreconditions.checkArgumentNotNull(response);
        KiwiPreconditions.checkArgumentNotNull(responseConsumer);
        try {
            responseConsumer.accept(response);
        }
        finally {
            KiwiResponses.closeQuietly(response);
        }
    }

    public static <T> T apply(Supplier<Response> responseSupplier, Function<Response, T> fun, Function<RuntimeException, T> exceptionFun) {
        KiwiPreconditions.checkArgumentNotNull(responseSupplier);
        KiwiPreconditions.checkArgumentNotNull(exceptionFun);
        WebCallResult result = KiwiResponses.getResponse(responseSupplier);
        if (result.hasResponse()) {
            return KiwiResponses.apply(result.response(), fun);
        }
        return exceptionFun.apply(result.error());
    }

    public static <T> T apply(Response response, Function<Response, T> fun) {
        KiwiPreconditions.checkArgumentNotNull(response);
        KiwiPreconditions.checkArgumentNotNull(fun);
        try {
            T t = fun.apply(response);
            return t;
        }
        finally {
            KiwiResponses.closeQuietly(response);
        }
    }

    @VisibleForTesting
    static WebCallResult getResponse(Supplier<Response> responseSupplier) {
        Response response = null;
        RuntimeException error = null;
        try {
            response = responseSupplier.get();
        }
        catch (RuntimeException e) {
            error = e;
        }
        if (Objects.nonNull(response)) {
            return WebCallResult.ofResponse(response);
        }
        if (Objects.nonNull(error)) {
            KiwiResponses.logResponseSupplierException(LOG, error);
            return WebCallResult.ofError(error);
        }
        LOG.warn("Response Supplier returned a null Response, which is not permitted");
        throw new IllegalStateException("Response returned by Supplier must not be null");
    }

    @VisibleForTesting
    static void logResponseSupplierException(Logger logger, RuntimeException error) {
        if (logger.isTraceEnabled()) {
            logger.trace("Response Supplier threw an exception", (Throwable)error);
        } else {
            logger.warn("Response Supplier unexpectedly threw: {}: {} (enable TRACE level to see stack trace)", (Object)error.getClass().getName(), (Object)error.getMessage());
        }
    }

    public static void closeQuietly(Response response) {
        if (Objects.nonNull(response)) {
            try {
                response.close();
            }
            catch (Exception e) {
                LOG.info("Error closing response", (Throwable)e);
            }
        }
    }

    @Generated
    private KiwiResponses() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    @VisibleForTesting
    record WebCallResult(RuntimeException error, Response response) {
        WebCallResult {
            KiwiPreconditions.checkOnlyOneArgumentIsNull(error, response, "Either the Response or the RuntimeException can be null, but not both");
        }

        static WebCallResult ofResponse(Response response) {
            return new WebCallResult(null, response);
        }

        static WebCallResult ofError(RuntimeException error) {
            return new WebCallResult(error, null);
        }

        boolean hasResponse() {
            return Objects.nonNull(this.response);
        }
    }

    private static class NoOpResponseConsumer
    implements Consumer<Response> {
        private NoOpResponseConsumer() {
        }

        @Override
        public void accept(Response response) {
        }
    }
}

