/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.jaxrs.exception;

import com.google.common.annotations.VisibleForTesting;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.kiwiproject.base.KiwiPreconditions;
import org.kiwiproject.jaxrs.exception.ErrorMessage;
import org.kiwiproject.jaxrs.exception.JaxrsException;

public class JaxrsValidationException
extends JaxrsException {
    public static final int CODE = 422;
    private static final String VALIDATION_FAILED_MESSAGE = "Validation failed";

    public JaxrsValidationException(String itemId, List<Map<String, String>> errorMessageMaps) {
        super(VALIDATION_FAILED_MESSAGE, 422);
        KiwiPreconditions.checkArgumentNotNull(errorMessageMaps);
        List<ErrorMessage> errorMessages = errorMessageMaps.stream().map(entry -> {
            String fieldName = (String)entry.get("fieldName");
            String message = (String)entry.get("message");
            return new ErrorMessage(itemId, 422, message, fieldName);
        }).toList();
        this.setErrors(errorMessages);
    }

    public JaxrsValidationException(String itemId, Set<? extends ConstraintViolation<?>> violations) {
        super(VALIDATION_FAILED_MESSAGE, 422);
        KiwiPreconditions.checkArgumentNotNull(violations);
        List<ErrorMessage> errorMessages = violations.stream().map(violation -> JaxrsValidationException.buildErrorMessage(itemId, violation)).toList();
        this.setErrors(errorMessages);
    }

    public JaxrsValidationException(String itemId, Set<? extends ConstraintViolation<?>> violations, Map<String, String> propertyPathMappings) {
        super(VALIDATION_FAILED_MESSAGE, 422);
        KiwiPreconditions.checkArgumentNotNull(violations);
        List<ErrorMessage> errorMessages = violations.stream().map(violation -> {
            String propertyPath = violation.getPropertyPath().toString();
            String fieldNameOrNull = (String)propertyPathMappings.get(propertyPath);
            return JaxrsValidationException.buildErrorMessage(itemId, violation, fieldNameOrNull);
        }).toList();
        this.setErrors(errorMessages);
    }

    public JaxrsValidationException(List<ErrorMessage> errorMessages) {
        super(VALIDATION_FAILED_MESSAGE, 422);
        KiwiPreconditions.checkArgumentNotNull(errorMessages);
        this.setErrors(errorMessages);
    }

    private static ErrorMessage buildErrorMessage(String itemId, @NotNull ConstraintViolation<?> violation) {
        KiwiPreconditions.checkArgumentNotNull(violation, "violation cannot be null");
        return JaxrsValidationException.buildErrorMessage(itemId, violation, violation.getPropertyPath().toString());
    }

    @VisibleForTesting
    static ErrorMessage buildErrorMessage(String itemId, @NotNull ConstraintViolation<?> violation, String fieldName) {
        KiwiPreconditions.checkArgumentNotNull(violation, "violation cannot be null");
        String fieldNameOrPropertyPath = Objects.nonNull(fieldName) ? fieldName : violation.getPropertyPath().toString();
        return new ErrorMessage(itemId, 422, violation.getMessage(), fieldNameOrPropertyPath);
    }

    public static JaxrsValidationException ofErrorMessages(List<ErrorMessage> errorMessages) {
        return new JaxrsValidationException(errorMessages);
    }
}

