/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.jdbc;

import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.kiwiproject.base.KiwiPreconditions;

public enum SqlOrder {
    ASC,
    DESC;


    public static SqlOrder from(String value) {
        String trimmedValue = Optional.ofNullable(value).map(String::trim).orElse("");
        if ("ASC".equalsIgnoreCase(trimmedValue)) {
            return ASC;
        }
        if ("DESC".equalsIgnoreCase(trimmedValue)) {
            return DESC;
        }
        throw new IllegalArgumentException("Invalid SQL order: " + value);
    }

    public <T> List<T> searchWith(Supplier<List<T>> ascSearch, Supplier<List<T>> descSearch) {
        KiwiPreconditions.checkArgumentNotNull(ascSearch, "Ascending search must be specified");
        KiwiPreconditions.checkArgumentNotNull(descSearch, "Descending search must be specified");
        if (this == ASC) {
            return ascSearch.get();
        }
        return descSearch.get();
    }

    public String toSql() {
        return this.name();
    }
}

