/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.jsch;

import io.dropwizard.util.Duration;
import io.dropwizard.validation.MinDuration;
import io.dropwizard.validation.PortRange;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import java.beans.ConstructorProperties;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class SftpConfig {
    private static final int DEFAULT_PORT = 22;
    private static final String DEFAULT_PREFERRED_AUTHENTICATIONS = "publickey,password";
    private static final Duration DEFAULT_TIMEOUT = Duration.seconds((long)5L);
    @PortRange
    private int port = 22;
    @NotBlank
    private String host;
    @NotBlank
    private String user;
    private String password;
    private String privateKeyFilePath;
    @NotBlank
    private String preferredAuthentications = "publickey,password";
    private String keyExchangeType;
    private String remoteBasePath;
    @NotBlank
    private String errorPath;
    @NotBlank
    private String knownHostsFile;
    private boolean disableStrictHostChecking;
    @NotNull
    @MinDuration(value=50L, unit=TimeUnit.MILLISECONDS)
    private @NotNull @MinDuration(value=50L, unit=TimeUnit.MILLISECONDS) Duration timeout = DEFAULT_TIMEOUT;

    @ConstructorProperties(value={"port", "host", "user", "password", "privateKeyFilePath", "preferredAuthentications", "keyExchangeType", "remoteBasePath", "errorPath", "knownHostsFile", "disableStrictHostChecking", "timeout"})
    public SftpConfig(int port, String host, String user, String password, String privateKeyFilePath, String preferredAuthentications, String keyExchangeType, String remoteBasePath, String errorPath, String knownHostsFile, boolean disableStrictHostChecking, Duration timeout) {
        this.port = port == 0 ? 22 : port;
        this.host = host;
        this.user = user;
        this.password = password;
        this.privateKeyFilePath = privateKeyFilePath;
        this.preferredAuthentications = StringUtils.isBlank((CharSequence)preferredAuthentications) ? DEFAULT_PREFERRED_AUTHENTICATIONS : preferredAuthentications;
        this.keyExchangeType = StringUtils.isBlank((CharSequence)keyExchangeType) ? null : keyExchangeType;
        this.remoteBasePath = remoteBasePath;
        this.errorPath = errorPath;
        this.knownHostsFile = knownHostsFile;
        this.disableStrictHostChecking = disableStrictHostChecking;
        this.timeout = Objects.isNull(timeout) ? DEFAULT_TIMEOUT : timeout;
    }

    @Generated
    public static SftpConfigBuilder builder() {
        return new SftpConfigBuilder();
    }

    @Generated
    public int getPort() {
        return this.port;
    }

    @Generated
    public String getHost() {
        return this.host;
    }

    @Generated
    public String getUser() {
        return this.user;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public String getPrivateKeyFilePath() {
        return this.privateKeyFilePath;
    }

    @Generated
    public String getPreferredAuthentications() {
        return this.preferredAuthentications;
    }

    @Generated
    public String getKeyExchangeType() {
        return this.keyExchangeType;
    }

    @Generated
    public String getRemoteBasePath() {
        return this.remoteBasePath;
    }

    @Generated
    public String getErrorPath() {
        return this.errorPath;
    }

    @Generated
    public String getKnownHostsFile() {
        return this.knownHostsFile;
    }

    @Generated
    public boolean isDisableStrictHostChecking() {
        return this.disableStrictHostChecking;
    }

    @Generated
    public Duration getTimeout() {
        return this.timeout;
    }

    @Generated
    public void setPort(int port) {
        this.port = port;
    }

    @Generated
    public void setHost(String host) {
        this.host = host;
    }

    @Generated
    public void setUser(String user) {
        this.user = user;
    }

    @Generated
    public void setPassword(String password) {
        this.password = password;
    }

    @Generated
    public void setPrivateKeyFilePath(String privateKeyFilePath) {
        this.privateKeyFilePath = privateKeyFilePath;
    }

    @Generated
    public void setPreferredAuthentications(String preferredAuthentications) {
        this.preferredAuthentications = preferredAuthentications;
    }

    @Generated
    public void setKeyExchangeType(String keyExchangeType) {
        this.keyExchangeType = keyExchangeType;
    }

    @Generated
    public void setRemoteBasePath(String remoteBasePath) {
        this.remoteBasePath = remoteBasePath;
    }

    @Generated
    public void setErrorPath(String errorPath) {
        this.errorPath = errorPath;
    }

    @Generated
    public void setKnownHostsFile(String knownHostsFile) {
        this.knownHostsFile = knownHostsFile;
    }

    @Generated
    public void setDisableStrictHostChecking(boolean disableStrictHostChecking) {
        this.disableStrictHostChecking = disableStrictHostChecking;
    }

    @Generated
    public void setTimeout(Duration timeout) {
        this.timeout = timeout;
    }

    @Generated
    public SftpConfig() {
    }

    @Generated
    public static class SftpConfigBuilder {
        @Generated
        private int port;
        @Generated
        private String host;
        @Generated
        private String user;
        @Generated
        private String password;
        @Generated
        private String privateKeyFilePath;
        @Generated
        private String preferredAuthentications;
        @Generated
        private String keyExchangeType;
        @Generated
        private String remoteBasePath;
        @Generated
        private String errorPath;
        @Generated
        private String knownHostsFile;
        @Generated
        private boolean disableStrictHostChecking;
        @Generated
        private Duration timeout;

        @Generated
        SftpConfigBuilder() {
        }

        @Generated
        public SftpConfigBuilder port(int port) {
            this.port = port;
            return this;
        }

        @Generated
        public SftpConfigBuilder host(String host) {
            this.host = host;
            return this;
        }

        @Generated
        public SftpConfigBuilder user(String user) {
            this.user = user;
            return this;
        }

        @Generated
        public SftpConfigBuilder password(String password) {
            this.password = password;
            return this;
        }

        @Generated
        public SftpConfigBuilder privateKeyFilePath(String privateKeyFilePath) {
            this.privateKeyFilePath = privateKeyFilePath;
            return this;
        }

        @Generated
        public SftpConfigBuilder preferredAuthentications(String preferredAuthentications) {
            this.preferredAuthentications = preferredAuthentications;
            return this;
        }

        @Generated
        public SftpConfigBuilder keyExchangeType(String keyExchangeType) {
            this.keyExchangeType = keyExchangeType;
            return this;
        }

        @Generated
        public SftpConfigBuilder remoteBasePath(String remoteBasePath) {
            this.remoteBasePath = remoteBasePath;
            return this;
        }

        @Generated
        public SftpConfigBuilder errorPath(String errorPath) {
            this.errorPath = errorPath;
            return this;
        }

        @Generated
        public SftpConfigBuilder knownHostsFile(String knownHostsFile) {
            this.knownHostsFile = knownHostsFile;
            return this;
        }

        @Generated
        public SftpConfigBuilder disableStrictHostChecking(boolean disableStrictHostChecking) {
            this.disableStrictHostChecking = disableStrictHostChecking;
            return this;
        }

        @Generated
        public SftpConfigBuilder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        @Generated
        public SftpConfig build() {
            return new SftpConfig(this.port, this.host, this.user, this.password, this.privateKeyFilePath, this.preferredAuthentications, this.keyExchangeType, this.remoteBasePath, this.errorPath, this.knownHostsFile, this.disableStrictHostChecking, this.timeout);
        }

        @Generated
        public String toString() {
            return "SftpConfig.SftpConfigBuilder(port=" + this.port + ", host=" + this.host + ", user=" + this.user + ", password=" + this.password + ", privateKeyFilePath=" + this.privateKeyFilePath + ", preferredAuthentications=" + this.preferredAuthentications + ", keyExchangeType=" + this.keyExchangeType + ", remoteBasePath=" + this.remoteBasePath + ", errorPath=" + this.errorPath + ", knownHostsFile=" + this.knownHostsFile + ", disableStrictHostChecking=" + this.disableStrictHostChecking + ", timeout=" + String.valueOf(this.timeout) + ")";
        }
    }
}

