/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.mongo;

import com.google.common.annotations.Beta;
import java.net.URI;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.kiwiproject.base.KiwiPreconditions;
import org.kiwiproject.base.KiwiStrings;

@Beta
public final class KiwiMongoDbs {
    public static String extractDbName(String mongoUri) {
        KiwiPreconditions.checkArgumentNotBlank(mongoUri, "mongoUri cannot be blank");
        return KiwiMongoDbs.extractDbName(URI.create(mongoUri));
    }

    public static String extractDbName(URI uri) {
        KiwiPreconditions.checkArgumentNotNull(uri, "uri cannot be null");
        String pathOrNull = uri.getPath();
        if (StringUtils.isBlank((CharSequence)pathOrNull) || "/".equals(pathOrNull)) {
            throw new IllegalArgumentException("Mongo connection URI does not contain a database name");
        }
        return pathOrNull.substring(1);
    }

    public static String extractHostInformation(String mongoUri) {
        KiwiPreconditions.checkArgumentNotBlank(mongoUri, "mongoUri cannot be blank");
        return KiwiMongoDbs.extractHostInformation(URI.create(mongoUri));
    }

    public static String extractHostInformation(URI uri) {
        KiwiPreconditions.checkArgumentNotNull(uri, "uri cannot be null");
        return KiwiStrings.f("{}://{}/", uri.getScheme(), uri.getAuthority());
    }

    @Generated
    private KiwiMongoDbs() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

