/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.retry;

import jakarta.ws.rs.core.Response;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.Objects;
import java.util.function.Predicate;
import javax.net.ssl.SSLHandshakeException;
import lombok.Generated;
import org.apache.commons.lang3.exception.ExceptionUtils;

public final class KiwiRetryerPredicates {
    public static final Predicate<Exception> UNKNOWN_HOST = ex -> ex instanceof UnknownHostException || ExceptionUtils.getRootCause((Throwable)ex) instanceof UnknownHostException;
    public static final Predicate<Exception> CONNECTION_ERROR = ex -> ex instanceof ConnectException || ExceptionUtils.getRootCause((Throwable)ex) instanceof ConnectException;
    public static final Predicate<Exception> SOCKET_TIMEOUT = ex -> ex instanceof SocketTimeoutException || ExceptionUtils.getRootCause((Throwable)ex) instanceof SocketTimeoutException;
    public static final Predicate<Exception> SSL_HANDSHAKE_ERROR = ex -> ex instanceof SSLHandshakeException || ExceptionUtils.indexOfType((Throwable)ex, SSLHandshakeException.class) > -1;
    public static final Predicate<Exception> NO_ROUTE_TO_HOST = ex -> ex instanceof NoRouteToHostException || ExceptionUtils.getRootCause((Throwable)ex) instanceof NoRouteToHostException;
    public static final Predicate<Response> IS_HTTP_400s = response -> Objects.nonNull(response) && Response.Status.Family.CLIENT_ERROR == response.getStatusInfo().getFamily();
    public static final Predicate<Response> IS_HTTP_500s = response -> Objects.nonNull(response) && Response.Status.Family.SERVER_ERROR == response.getStatusInfo().getFamily();

    @Generated
    private KiwiRetryerPredicates() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

