/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.spring.data;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Generated;
import org.apache.commons.lang3.EnumUtils;
import org.kiwiproject.base.KiwiPreconditions;

@JsonIgnoreProperties(ignoreUnknown=true)
public class KiwiSort {
    @JsonIgnore
    private Direction directionObject;
    private String direction;
    private String property;
    private boolean ignoreCase;
    private boolean ascending;

    public static KiwiSort ofAscending(String property) {
        return KiwiSort.of(property, Direction.ASC);
    }

    public static KiwiSort ofDescending(String property) {
        return KiwiSort.of(property, Direction.DESC);
    }

    public static KiwiSort of(String property, String direction) {
        KiwiPreconditions.checkArgumentNotBlank(property);
        KiwiPreconditions.checkArgumentNotBlank(direction);
        return KiwiSort.of(property, Direction.fromString(direction));
    }

    public static KiwiSort of(String property, Direction direction) {
        KiwiPreconditions.checkArgumentNotBlank(property);
        KiwiPreconditions.checkArgumentNotNull(direction);
        KiwiSort sort = new KiwiSort();
        sort.setProperty(property);
        sort.setDirectionObject(direction);
        sort.setDirection(direction.name());
        sort.setAscending(direction.isAscending());
        sort.setIgnoreCase(false);
        return sort;
    }

    public KiwiSort ignoringCase() {
        this.setIgnoreCase(true);
        return this;
    }

    public boolean isDescending() {
        return !this.ascending;
    }

    @Generated
    public Direction getDirectionObject() {
        return this.directionObject;
    }

    @Generated
    public String getDirection() {
        return this.direction;
    }

    @Generated
    public String getProperty() {
        return this.property;
    }

    @Generated
    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    @Generated
    public boolean isAscending() {
        return this.ascending;
    }

    @JsonIgnore
    @Generated
    public void setDirectionObject(Direction directionObject) {
        this.directionObject = directionObject;
    }

    @Generated
    public void setDirection(String direction) {
        this.direction = direction;
    }

    @Generated
    public void setProperty(String property) {
        this.property = property;
    }

    @Generated
    public void setIgnoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
    }

    @Generated
    public void setAscending(boolean ascending) {
        this.ascending = ascending;
    }

    @Generated
    public String toString() {
        return "KiwiSort(directionObject=" + String.valueOf((Object)this.getDirectionObject()) + ", direction=" + this.getDirection() + ", property=" + this.getProperty() + ", ignoreCase=" + this.isIgnoreCase() + ", ascending=" + this.isAscending() + ")";
    }

    public static enum Direction {
        ASC(true),
        DESC(false);

        public final boolean ascending;

        private Direction(boolean ascending) {
            this.ascending = ascending;
        }

        public static Direction fromString(String value) {
            KiwiPreconditions.checkArgumentNotBlank(value, "direction value must not be blank");
            Direction direction = (Direction)EnumUtils.getEnumIgnoreCase(Direction.class, (String)value.strip());
            KiwiPreconditions.checkArgumentNotNull(direction, "no matching enum constant found in Direction");
            return direction;
        }

        public boolean isDescending() {
            return !this.ascending;
        }

        @Generated
        public boolean isAscending() {
            return this.ascending;
        }
    }
}

