/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.time;

import com.google.common.base.Preconditions;
import io.dropwizard.util.Duration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.kiwiproject.base.KiwiDeprecated;

public final class KiwiDurationFormatters {
    private static final boolean SUPPRESS_LEADING_ZERO_ELEMENTS = true;
    private static final boolean SUPPRESS_TRAILING_ZERO_ELEMENTS = true;
    private static final String LITERAL_NULL = "null";
    private static final String ZERO_SECONDS_MESSAGE = "0 seconds";
    private static final int NANOSECONDS_IN_ONE_MILLISECOND = 1000000;
    private static final int MILLISECONDS_IN_ONE_SECOND = 1000;

    @Deprecated(since="4.6.0", forRemoval=true)
    @KiwiDeprecated(replacedBy={"formatJavaDurationWords(java.time.Duration duration)"}, usageSeverity=KiwiDeprecated.Severity.SEVERE, removeAt="5.0.0")
    public static String formatDurationWords(java.time.Duration duration) {
        if (Objects.isNull(duration)) {
            return LITERAL_NULL;
        }
        return KiwiDurationFormatters.formatDurationWords(duration.toMillis());
    }

    public static String formatJavaDurationWords(java.time.Duration duration) {
        if (Objects.isNull(duration)) {
            return LITERAL_NULL;
        }
        if (duration.isZero()) {
            return ZERO_SECONDS_MESSAGE;
        }
        return KiwiDurationFormatters.formatNanosecondDurationWords(duration.toNanos());
    }

    @Deprecated(since="4.6.0", forRemoval=true)
    @KiwiDeprecated(replacedBy={"formatDropwizardDurationWords(io.dropwizard.util.Duration duration)"}, usageSeverity=KiwiDeprecated.Severity.SEVERE, removeAt="5.0.0")
    public static String formatDurationWords(Duration duration) {
        if (Objects.isNull(duration)) {
            return LITERAL_NULL;
        }
        return KiwiDurationFormatters.formatDurationWords(duration.toMilliseconds());
    }

    public static String formatDropwizardDurationWords(Duration duration) {
        if (Objects.isNull(duration)) {
            return LITERAL_NULL;
        }
        if (duration.getQuantity() == 0L) {
            return ZERO_SECONDS_MESSAGE;
        }
        return KiwiDurationFormatters.formatNanosecondDurationWords(duration.toNanoseconds());
    }

    @Deprecated(since="4.6.0", forRemoval=true)
    @KiwiDeprecated(replacedBy={"formatMillisecondDurationWords(long durationMillis)"}, usageSeverity=KiwiDeprecated.Severity.SEVERE, removeAt="5.0.0")
    public static String formatDurationWords(long durationMillis) {
        return DurationFormatUtils.formatDurationWords((long)durationMillis, (boolean)true, (boolean)true);
    }

    public static String formatMillisecondDurationWords(long durationMillis) {
        Preconditions.checkArgument((durationMillis >= 0L ? 1 : 0) != 0, (Object)"duration must not be negative");
        if (durationMillis == 0L) {
            return "0 milliseconds";
        }
        if (durationMillis < 1000L) {
            return durationMillis + KiwiDurationFormatters.milliUnit(durationMillis);
        }
        return DurationFormatUtils.formatDurationWords((long)durationMillis, (boolean)true, (boolean)true);
    }

    public static String formatNanosecondDurationWords(long durationNanos) {
        Preconditions.checkArgument((durationNanos >= 0L ? 1 : 0) != 0, (Object)"duration must not be negative");
        if (durationNanos == 0L) {
            return "0 nanoseconds";
        }
        if (durationNanos < 1000000L) {
            return durationNanos + KiwiDurationFormatters.nanoUnit(durationNanos);
        }
        long durationMillis = TimeUnit.NANOSECONDS.toMillis(durationNanos);
        if (durationMillis < 1000L) {
            return durationMillis + KiwiDurationFormatters.milliUnit(durationMillis);
        }
        return DurationFormatUtils.formatDurationWords((long)durationMillis, (boolean)true, (boolean)true);
    }

    private static String nanoUnit(long durationNanos) {
        return durationNanos == 1L ? " nanosecond" : " nanoseconds";
    }

    private static String milliUnit(long durationMillis) {
        return durationMillis == 1L ? " millisecond" : " milliseconds";
    }

    @Generated
    private KiwiDurationFormatters() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

