/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.validation;

import com.google.common.annotations.VisibleForTesting;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.validator.routines.UrlValidator;
import org.kiwiproject.validation.ValidURL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidURLValidator
implements ConstraintValidator<ValidURL, CharSequence> {
    @Generated
    private static final Logger LOG = LoggerFactory.getLogger(ValidURLValidator.class);
    private ValidURL validURL;
    private UrlValidator validator;

    public void initialize(ValidURL constraintAnnotation) {
        this.validURL = constraintAnnotation;
        long options = ValidURLValidator.buildOptionsForCommonsUrlValidator(this.validURL);
        this.validator = this.validURL.allowAllSchemes() ? new UrlValidator(options) : new UrlValidator(this.validURL.allowSchemes(), options);
    }

    private static long buildOptionsForCommonsUrlValidator(ValidURL url) {
        long options;
        long l = options = url.allowAllSchemes() ? 1L : 0L;
        if (url.allowLocalUrls()) {
            options += 8L;
        }
        if (url.allowTwoSlashes()) {
            options += 2L;
        }
        if (!url.allowFragments()) {
            options += 4L;
        }
        return options;
    }

    public boolean isValid(CharSequence value, ConstraintValidatorContext context) {
        if (Objects.isNull(value)) {
            return this.validURL.allowNull();
        }
        String string = value.toString();
        boolean valid = this.validator.isValid(string);
        if (!valid) {
            LOG.trace("'{}' is NOT valid according to UrlValidator. Skip edge-case checks.", (Object)string);
            return false;
        }
        LOG.trace("'{}' is valid according to UrlValidator. Check edge-cases.", (Object)string);
        return ValidURLValidator.checkEdgeCases(string, this.validURL.allowLocalUrls());
    }

    @VisibleForTesting
    static boolean checkEdgeCases(String string, boolean allowLocalUrls) {
        LoopbackCheckResult loopbackResult;
        UriParseResult result = ValidURLValidator.parseUri(string);
        Exception error = result.error();
        if (Objects.nonNull(error)) {
            LOG.trace("UrlValidator reported valid, but URI#create threw exception for '{}'", (Object)string, (Object)error);
            return false;
        }
        URI uri = result.uri();
        String authority = uri.getAuthority();
        if (Objects.nonNull(authority) && authority.endsWith(":")) {
            LOG.trace("Authority should not end with a colon but no port: '{}'", (Object)authority);
            return false;
        }
        String host = uri.getHost();
        if (!allowLocalUrls && Objects.nonNull(host) && (loopbackResult = ValidURLValidator.checkLoopbackIpAddress(host)).isLoopbackOrError()) {
            LOG.trace("Loopback check for host '{}' failed. Is loopback? {}, Error? {}", new Object[]{host, loopbackResult.isLoopback(), loopbackResult.isError(), loopbackResult.error()});
            return false;
        }
        return true;
    }

    private static UriParseResult parseUri(String string) {
        try {
            return new UriParseResult(URI.create(string), null);
        }
        catch (Exception e) {
            return new UriParseResult(null, e);
        }
    }

    @VisibleForTesting
    static LoopbackCheckResult checkLoopbackIpAddress(String host) {
        try {
            boolean isLoopback = InetAddress.getByName(host).isLoopbackAddress();
            return new LoopbackCheckResult(isLoopback, null);
        }
        catch (UnknownHostException e) {
            LOG.trace("Error getting InetAddress by name for host: {}", (Object)host, (Object)e);
            return new LoopbackCheckResult(false, e);
        }
    }

    private record UriParseResult(URI uri, Exception error) {
    }

    @VisibleForTesting
    record LoopbackCheckResult(boolean isLoopback, Exception error) {
        boolean isLoopbackOrError() {
            return this.isLoopback || this.isError();
        }

        boolean isError() {
            return Objects.nonNull(this.error);
        }
    }
}

