package org.kiwiproject.jaxrs.exception;

import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.Provider;

/**
 * Map {@link IllegalArgumentException} to {@link Response}.
 * <p>
 * The mapped response has status code 400 (Bad Request) and media type JSON.
 */
@Provider
public class IllegalArgumentExceptionMapper implements ExceptionMapper<IllegalArgumentException> {

    /**
     * Convert the given {@link IllegalArgumentException} to a 400 Bad Request response containing a JSON entity.
     *
     * @param exception the exception to convert
     * @return a response
     * @see JaxrsExceptionMapper#buildResponse(JaxrsException)
     */
    @Override
    public Response toResponse(IllegalArgumentException exception) {
        return JaxrsExceptionMapper.buildResponse(new JaxrsBadRequestException(exception));
    }
}
