/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.net;

import lombok.Generated;

public final class KiwiHttpResponses {
    public static boolean informational(int statusCode) {
        return KiwiHttpResponses.isInFamily(statusCode, 1);
    }

    public static boolean successful(int statusCode) {
        return KiwiHttpResponses.isInFamily(statusCode, 2);
    }

    public static boolean notSuccessful(int statusCode) {
        return !KiwiHttpResponses.successful(statusCode);
    }

    public static boolean redirection(int statusCode) {
        return KiwiHttpResponses.isInFamily(statusCode, 3);
    }

    public static boolean clientError(int statusCode) {
        return KiwiHttpResponses.isInFamily(statusCode, 4);
    }

    public static boolean serverError(int statusCode) {
        return KiwiHttpResponses.isInFamily(statusCode, 5);
    }

    public static boolean otherFamily(int statusCode) {
        int firstDigit = KiwiHttpResponses.firstDigitInFamily(statusCode);
        return firstDigit < 1 || firstDigit > 5;
    }

    private static boolean isInFamily(int statusCode, int expectedFirstDigit) {
        return KiwiHttpResponses.firstDigitInFamily(statusCode) == expectedFirstDigit;
    }

    private static int firstDigitInFamily(int statusCode) {
        return statusCode / 100;
    }

    public static boolean ok(int statusCode) {
        return statusCode == 200;
    }

    public static boolean created(int statusCode) {
        return statusCode == 201;
    }

    public static boolean accepted(int statusCode) {
        return statusCode == 202;
    }

    public static boolean noContent(int statusCode) {
        return statusCode == 204;
    }

    public static boolean resetContent(int statusCode) {
        return statusCode == 205;
    }

    public static boolean partialContent(int statusCode) {
        return statusCode == 206;
    }

    public static boolean movedPermanently(int statusCode) {
        return statusCode == 301;
    }

    public static boolean found(int statusCode) {
        return statusCode == 302;
    }

    public static boolean seeOther(int statusCode) {
        return statusCode == 303;
    }

    public static boolean notModified(int statusCode) {
        return statusCode == 304;
    }

    public static boolean temporaryRedirect(int statusCode) {
        return statusCode == 307;
    }

    public static boolean permanentRedirect(int statusCode) {
        return statusCode == 308;
    }

    public static boolean badRequest(int statusCode) {
        return statusCode == 400;
    }

    public static boolean unauthorized(int statusCode) {
        return statusCode == 401;
    }

    public static boolean paymentRequired(int statusCode) {
        return statusCode == 402;
    }

    public static boolean forbidden(int statusCode) {
        return statusCode == 403;
    }

    public static boolean notFound(int statusCode) {
        return statusCode == 404;
    }

    public static boolean methodNotAllowed(int statusCode) {
        return statusCode == 405;
    }

    public static boolean notAcceptable(int statusCode) {
        return statusCode == 406;
    }

    public static boolean proxyAuthenticationRequired(int statusCode) {
        return statusCode == 407;
    }

    public static boolean requestTimeout(int statusCode) {
        return statusCode == 408;
    }

    public static boolean conflict(int statusCode) {
        return statusCode == 409;
    }

    public static boolean gone(int statusCode) {
        return statusCode == 410;
    }

    public static boolean lengthRequired(int statusCode) {
        return statusCode == 411;
    }

    public static boolean preconditionFailed(int statusCode) {
        return statusCode == 412;
    }

    public static boolean contentTooLarge(int statusCode) {
        return statusCode == 413;
    }

    public static boolean uriTooLong(int statusCode) {
        return statusCode == 414;
    }

    public static boolean unsupportedMediaType(int statusCode) {
        return statusCode == 415;
    }

    public static boolean rangeNotSatisfiable(int statusCode) {
        return statusCode == 416;
    }

    public static boolean expectationFailed(int statusCode) {
        return statusCode == 417;
    }

    public static boolean iAmATeapot(int statusCode) {
        return statusCode == 418;
    }

    public static boolean unprocessableContent(int statusCode) {
        return statusCode == 422;
    }

    public static boolean upgradeRequired(int statusCode) {
        return statusCode == 426;
    }

    public static boolean preconditionRequired(int statusCode) {
        return statusCode == 428;
    }

    public static boolean tooManyRequests(int statusCode) {
        return statusCode == 429;
    }

    public static boolean requestHeaderFieldsTooLarge(int statusCode) {
        return statusCode == 431;
    }

    public static boolean internalServerError(int statusCode) {
        return statusCode == 500;
    }

    public static boolean notImplemented(int statusCode) {
        return statusCode == 501;
    }

    public static boolean badGateway(int statusCode) {
        return statusCode == 502;
    }

    public static boolean serviceUnavailable(int statusCode) {
        return statusCode == 503;
    }

    public static boolean gatewayTimeout(int statusCode) {
        return statusCode == 504;
    }

    public static boolean httpVersionNotSupported(int statusCode) {
        return statusCode == 505;
    }

    public static boolean networkAuthenticationRequired(int statusCode) {
        return statusCode == 511;
    }

    public static String reasonPhraseOf(int statusCode) {
        return switch (statusCode) {
            case 100 -> "Continue";
            case 101 -> "Switching Protocols";
            case 102 -> "Processing";
            case 103 -> "Early Hints";
            case 200 -> "OK";
            case 201 -> "Created";
            case 202 -> "Accepted";
            case 203 -> "Non-Authoritative Information";
            case 204 -> "No Content";
            case 205 -> "Reset Content";
            case 206 -> "Partial Content";
            case 207 -> "Multi-Status";
            case 208 -> "Already Reported";
            case 226 -> "IM Used";
            case 300 -> "Multiple Choices";
            case 301 -> "Moved Permanently";
            case 302 -> "Found";
            case 303 -> "See Other";
            case 304 -> "Not Modified";
            case 305 -> "Use Proxy";
            case 306 -> "unused";
            case 307 -> "Temporary Redirect";
            case 308 -> "Permanent Redirect";
            case 400 -> "Bad Request";
            case 401 -> "Unauthorized";
            case 402 -> "Payment Required";
            case 403 -> "Forbidden";
            case 404 -> "Not Found";
            case 405 -> "Method Not Allowed";
            case 406 -> "Not Acceptable";
            case 407 -> "Proxy Authentication Required";
            case 408 -> "Request Timeout";
            case 409 -> "Conflict";
            case 410 -> "Gone";
            case 411 -> "Length Required";
            case 412 -> "Precondition Failed";
            case 413 -> "Content Too Large";
            case 414 -> "URI Too Long";
            case 415 -> "Unsupported Media Type";
            case 416 -> "Range Not Satisfiable";
            case 417 -> "Expectation Failed";
            case 418 -> "I'm a teapot";
            case 421 -> "Misdirected Request";
            case 422 -> "Unprocessable Content";
            case 423 -> "Locked";
            case 424 -> "Failed Dependency";
            case 425 -> "Too Early";
            case 426 -> "Upgrade Required";
            case 428 -> "Precondition Required";
            case 429 -> "Too Many Requests";
            case 431 -> "Request Header Fields Too Large";
            case 451 -> "Unavailable For Legal Reasons";
            case 500 -> "Internal Server Error";
            case 501 -> "Not Implemented";
            case 502 -> "Bad Gateway";
            case 503 -> "Service Unavailable";
            case 504 -> "Gateway Timeout";
            case 505 -> "HTTP Version Not Supported";
            case 506 -> "Variant Also Negotiates";
            case 507 -> "Insufficient Storage";
            case 508 -> "Loop Detected";
            case 510 -> "Not Extended";
            case 511 -> "Network Authentication Required";
            default -> "Unknown";
        };
    }

    @Generated
    private KiwiHttpResponses() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

