/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.collect;

import com.google.common.base.Preconditions;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.IntStream;
import lombok.Generated;

public final class KiwiArrays {
    public static <T> boolean isNullOrEmpty(T[] items) {
        return items == null || items.length == 0;
    }

    public static <T> boolean isNotNullOrEmpty(T[] items) {
        return !KiwiArrays.isNullOrEmpty(items);
    }

    public static <T> boolean hasOneElement(T[] items) {
        return Objects.nonNull(items) && items.length == 1;
    }

    public static <T> T[] sorted(T[] items, Class<T> arrayType) {
        KiwiArrays.checkNonNullInputArray(items);
        return Arrays.stream(items).sorted().toArray(size -> (Object[])Array.newInstance(arrayType, size));
    }

    public static <T> T[] sorted(T[] items, Comparator<T> comparator, Class<T> arrayType) {
        KiwiArrays.checkNonNullInputArray(items);
        Preconditions.checkNotNull(comparator, (Object)"Comparator cannot be null");
        return Arrays.stream(items).sorted(comparator).toArray(size -> (Object[])Array.newInstance(arrayType, size));
    }

    public static <T> T first(T[] items) {
        return KiwiArrays.nth(items, 1);
    }

    public static <T> Optional<T> firstIfPresent(T[] items) {
        return KiwiArrays.isNotNullOrEmpty(items) ? Optional.of(KiwiArrays.first(items)) : Optional.empty();
    }

    public static <T> T second(T[] items) {
        return KiwiArrays.nth(items, 2);
    }

    public static <T> T third(T[] items) {
        return KiwiArrays.nth(items, 3);
    }

    public static <T> T fourth(T[] items) {
        return KiwiArrays.nth(items, 4);
    }

    public static <T> T fifth(T[] items) {
        return KiwiArrays.nth(items, 5);
    }

    public static <T> T penultimate(T[] items) {
        KiwiArrays.checkMinimumSize(items, 2);
        return KiwiArrays.nth(items, items.length - 1);
    }

    public static <T> T secondToLast(T[] items) {
        return KiwiArrays.penultimate(items);
    }

    public static <T> T last(T[] items) {
        return KiwiArrays.nth(items, items.length);
    }

    public static <T> Optional<T> lastIfPresent(T[] items) {
        return KiwiArrays.isNotNullOrEmpty(items) ? Optional.of(KiwiArrays.last(items)) : Optional.empty();
    }

    public static <T> T nth(T[] items, int number) {
        KiwiArrays.checkMinimumSize(items, number);
        return items[number - 1];
    }

    public static <T> T[] distinct(T[] collection, Class<T> arrayType) {
        Preconditions.checkArgument((boolean)Objects.nonNull(collection), (Object)"collection can not be null");
        return KiwiArrays.distinctOrNull(collection, arrayType);
    }

    public static <T> T[] distinctOrNull(T[] collection, Class<T> arrayType) {
        if (Objects.isNull(collection)) {
            return null;
        }
        return Arrays.stream(collection).distinct().toArray(val -> (Object[])Array.newInstance(arrayType, val));
    }

    public static <T> T[] newArrayStartingAtCircularOffset(T[] input, long startOffset, Class<T> arrayType) {
        int size = input.length;
        return IntStream.range(0, size).mapToObj(i -> input[(int)(startOffset + (long)i) % size]).toArray(val -> (Object[])Array.newInstance(arrayType, val));
    }

    public static <T> T[] subArrayExcludingFirst(T[] items) {
        KiwiArrays.checkNonNullInputArray(items);
        if (items.length == 0) {
            return KiwiArrays.zeroSubArray(items);
        }
        return Arrays.copyOfRange(items, 1, items.length);
    }

    public static <T> T[] subArrayExcludingLast(T[] items) {
        KiwiArrays.checkNonNullInputArray(items);
        if (items.length == 0) {
            return KiwiArrays.zeroSubArray(items);
        }
        return Arrays.copyOfRange(items, 0, items.length - 1);
    }

    private static <T> T[] zeroSubArray(T[] items) {
        return Arrays.copyOf(items, 0);
    }

    public static <T> T[] subArrayFrom(T[] items, int number) {
        KiwiArrays.checkMinimumSize(items, number);
        return Arrays.copyOfRange(items, number - 1, items.length);
    }

    public static <T> T[] subArrayFromIndex(T[] items, int index) {
        KiwiArrays.checkMinimumSize(items, index + 1);
        return Arrays.copyOfRange(items, index, items.length);
    }

    public static <T> T[] firstN(T[] items, int number) {
        KiwiArrays.checkNonNullInputArray(items);
        KiwiArrays.checkMinSizeIsPositive(number);
        if (number > items.length) {
            return items;
        }
        return Arrays.copyOfRange(items, 0, number);
    }

    public static <T> T[] lastN(T[] items, int number) {
        KiwiArrays.checkNonNullInputArray(items);
        KiwiArrays.checkMinSizeIsPositive(number);
        if (number > items.length) {
            return items;
        }
        int startIndex = items.length - number;
        return Arrays.copyOfRange(items, startIndex, items.length);
    }

    public static <T> void checkMinimumSize(T[] items, int minSize) {
        KiwiArrays.checkNonNullInputArray(items);
        KiwiArrays.checkMinSizeIsPositive(minSize);
        Preconditions.checkArgument((items.length >= minSize ? 1 : 0) != 0, (String)"expected at least %s items (actual size: %s)", (int)minSize, (int)items.length);
    }

    private static void checkMinSizeIsPositive(int minSize) {
        Preconditions.checkArgument((minSize > 0 ? 1 : 0) != 0, (Object)"number must be positive");
    }

    public static <T> void checkNonNullInputArray(T[] items) {
        Preconditions.checkNotNull(items, (Object)"items cannot be null");
    }

    @Generated
    private KiwiArrays() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

