/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.concurrent;

import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import lombok.Generated;
import org.kiwiproject.base.KiwiPreconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TryLocker {
    @Generated
    private static final Logger LOG = LoggerFactory.getLogger(TryLocker.class);
    public static final int DEFAULT_LOCK_WAIT_TIME = 50;
    public static final TimeUnit DEFAULT_LOCK_WAIT_TIME_UNIT = TimeUnit.MILLISECONDS;
    private final Lock lock;
    private final long lockWaitTime;
    private final TimeUnit lockWaitTimeUnit;

    private TryLocker(Lock lock, long lockWaitTime, TimeUnit lockWaitTimeUnit) {
        this.lock = lock;
        this.lockWaitTime = lockWaitTime;
        this.lockWaitTimeUnit = lockWaitTimeUnit;
    }

    public static TryLocker usingReentrantLock() {
        return TryLocker.usingReentrantLock(50, DEFAULT_LOCK_WAIT_TIME_UNIT);
    }

    public static TryLocker usingReentrantLock(int maxWaitTime, TimeUnit maxWaitTimeUnit) {
        return TryLocker.using(new ReentrantLock(), maxWaitTime, maxWaitTimeUnit);
    }

    public static TryLocker using(Lock lock, long maxWaitTime, TimeUnit maxWaitTimeUnit) {
        return new TryLocker(lock, maxWaitTime, maxWaitTimeUnit);
    }

    public Duration getLockWaitDuration() {
        return Duration.ofMillis(this.lockWaitTimeUnit.toMillis(this.lockWaitTime));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void withLockOrElse(Runnable withLockAction, Runnable orElseAction) {
        boolean gotLock = false;
        try {
            gotLock = this.lock.tryLock(this.lockWaitTime, this.lockWaitTimeUnit);
            LOG.trace("Got lock {} within wait time {} {}? {}", new Object[]{this.lock, this.lockWaitTime, this.lockWaitTimeUnit, gotLock});
            Runnable action = TryLocker.selectAction(gotLock, withLockAction, orElseAction);
            action.run();
        }
        catch (InterruptedException e) {
            LOG.warn("Interrupted waiting for lock", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        finally {
            this.unlockOnlyIf(gotLock);
        }
    }

    private static Runnable selectAction(boolean gotLock, Runnable withLockAction, Runnable orElseAction) {
        if (gotLock) {
            return withLockAction;
        }
        return orElseAction;
    }

    public <T> T withLockSupplyOrNull(Supplier<T> withLockSupplier) {
        return this.getWithLockOrNull(withLockSupplier);
    }

    public <T> T withLockSupplyOrFallback(Supplier<T> withLockSupplier, T fallbackValue) {
        T result = this.getWithLockOrNull(withLockSupplier);
        return Objects.nonNull(result) ? result : fallbackValue;
    }

    public <T> T withLockSupplyOrFallbackSupply(Supplier<T> withLockSupplier, Supplier<T> fallbackSupplier) {
        T result = this.getWithLockOrNull(withLockSupplier);
        return Objects.nonNull(result) ? result : fallbackSupplier.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T getWithLockOrNull(Supplier<T> withLockSupplier) {
        KiwiPreconditions.checkArgumentNotNull(withLockSupplier);
        boolean gotLock = false;
        T result = null;
        try {
            gotLock = this.lock.tryLock(this.lockWaitTime, this.lockWaitTimeUnit);
            LOG.trace("Got lock {} within wait time {} {}? {}", new Object[]{this.lock, this.lockWaitTime, this.lockWaitTimeUnit, gotLock});
            if (gotLock) {
                result = withLockSupplier.get();
            }
        }
        catch (InterruptedException e) {
            LOG.warn("Interrupted waiting for lock", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        finally {
            this.unlockOnlyIf(gotLock);
        }
        return result;
    }

    private void unlockOnlyIf(boolean gotLock) {
        if (gotLock) {
            this.lock.unlock();
        }
    }

    @Generated
    public long getLockWaitTime() {
        return this.lockWaitTime;
    }

    @Generated
    public TimeUnit getLockWaitTimeUnit() {
        return this.lockWaitTimeUnit;
    }
}

