/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.dropwizard.jdbi3;

import io.dropwizard.core.setup.Environment;
import io.dropwizard.db.ManagedDataSource;
import io.dropwizard.db.PooledDataSourceFactory;
import io.dropwizard.jdbi3.JdbiFactory;
import java.util.Arrays;
import java.util.function.Predicate;
import lombok.Generated;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.kiwiproject.base.KiwiPreconditions;
import org.kiwiproject.dropwizard.jdbi3.DatabaseType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Jdbi3Builders {
    @Generated
    private static final Logger LOG = LoggerFactory.getLogger(Jdbi3Builders.class);
    public static final String DEFAULT_HEALTH_CHECK_NAME = "database";
    private static final String NULL_ENVIRONMENT_MESSAGE = "Environment cannot be null";
    private static final String NULL_DATA_SOURCE_FACTORY_NAME = "PooledDataSourceFactory cannot be null";
    private static final String NULL_DATA_SOURCE_MESSAGE = "ManagedDataSource cannot be null";

    public static Jdbi buildManagedJdbi(Environment environment, PooledDataSourceFactory dataSourceFactory, JdbiPlugin ... jdbiPlugins) {
        return Jdbi3Builders.buildManagedJdbi(environment, dataSourceFactory, DEFAULT_HEALTH_CHECK_NAME, jdbiPlugins);
    }

    public static Jdbi buildManagedJdbi(Environment environment, PooledDataSourceFactory dataSourceFactory, String healthCheckName, JdbiPlugin ... jdbiPlugins) {
        KiwiPreconditions.checkArgumentNotNull(environment, NULL_ENVIRONMENT_MESSAGE);
        KiwiPreconditions.checkArgumentNotNull(dataSourceFactory, NULL_DATA_SOURCE_FACTORY_NAME);
        ManagedDataSource managedDataSource = dataSourceFactory.build(environment.metrics(), healthCheckName);
        return Jdbi3Builders.buildManagedJdbi(environment, dataSourceFactory, managedDataSource, healthCheckName, jdbiPlugins);
    }

    public static Jdbi buildManagedJdbi(Environment environment, PooledDataSourceFactory dataSourceFactory, ManagedDataSource dataSource, JdbiPlugin ... jdbiPlugins) {
        return Jdbi3Builders.buildManagedJdbi(environment, dataSourceFactory, dataSource, DEFAULT_HEALTH_CHECK_NAME, jdbiPlugins);
    }

    public static Jdbi buildManagedJdbi(Environment environment, PooledDataSourceFactory dataSourceFactory, ManagedDataSource managedDataSource, String healthCheckName, JdbiPlugin ... jdbiPlugins) {
        KiwiPreconditions.checkArgumentNotNull(environment, NULL_ENVIRONMENT_MESSAGE);
        KiwiPreconditions.checkArgumentNotNull(dataSourceFactory, NULL_DATA_SOURCE_FACTORY_NAME);
        KiwiPreconditions.checkArgumentNotNull(managedDataSource, NULL_DATA_SOURCE_MESSAGE);
        JdbiFactory factory = new JdbiFactory();
        Jdbi jdbi = factory.build(environment, dataSourceFactory, managedDataSource, healthCheckName);
        Jdbi3Builders.installPlugins(jdbi, dataSourceFactory, jdbiPlugins);
        LOG.debug("Created JDBI v3 instance: {}", (Object)jdbi);
        return jdbi;
    }

    private static void installPlugins(Jdbi jdbi, PooledDataSourceFactory dataSourceFactory, JdbiPlugin ... jdbiPlugins) {
        DatabaseType.pluginFromDatabaseUrl(dataSourceFactory.getUrl()).ifPresent(plugin -> {
            LOG.debug("Installing database plugin {}", (Object)plugin.getClass().getName());
            jdbi.installPlugin(plugin);
        });
        jdbi.installPlugin((JdbiPlugin)new SqlObjectPlugin());
        Arrays.stream(jdbiPlugins).filter(Predicate.not(Jdbi3Builders::isSqlObjectPlugin)).forEach(arg_0 -> ((Jdbi)jdbi).installPlugin(arg_0));
    }

    private static boolean isSqlObjectPlugin(JdbiPlugin jdbiPlugin) {
        return jdbiPlugin instanceof SqlObjectPlugin;
    }

    @Generated
    private Jdbi3Builders() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

