/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.jar;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.security.CodeSource;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.jar.Manifest;
import java.util.stream.StreamSupport;
import lombok.Generated;
import org.kiwiproject.base.KiwiPreconditions;
import org.kiwiproject.collect.KiwiLists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KiwiJars {
    @Generated
    private static final Logger LOG = LoggerFactory.getLogger(KiwiJars.class);

    public static List<String> getPathComponents(Class<?> classInJar) {
        KiwiPreconditions.checkArgumentNotNull(classInJar, "classInJar cannot be null");
        try {
            CodeSource codeSource = classInJar.getProtectionDomain().getCodeSource();
            Preconditions.checkNotNull((Object)codeSource, (String)"Code source for %s is null", classInJar);
            String encodedJarPath = codeSource.getLocation().getPath();
            String decodedJarPath = URLDecoder.decode(encodedJarPath, StandardCharsets.UTF_8);
            return Lists.newArrayList((Object[])decodedJarPath.trim().split(File.separator));
        }
        catch (Exception e) {
            return KiwiJars.logExceptionAndReturnEmptyList(e, classInJar);
        }
    }

    @VisibleForTesting
    static List<String> logExceptionAndReturnEmptyList(Exception ex, Class<?> classInJar) {
        LOG.error("Error getting Jar path components for {}! (turn on DEBUG logging to see stack traces)", classInJar);
        LOG.debug("Exception related to {}:", classInJar, (Object)ex);
        return Collections.emptyList();
    }

    public static Optional<String> getPath(Class<?> classInJar) {
        List<String> pathComponents = KiwiJars.getPathComponents(classInJar);
        return KiwiJars.joined(pathComponents);
    }

    public static Optional<String> getDirectoryPath(Class<?> classInJar) {
        List<String> pathComponents = KiwiJars.getPathComponents(classInJar);
        Preconditions.checkState((boolean)KiwiLists.isNotNullOrEmpty(pathComponents), (Object)"there must be at least one path component!");
        return KiwiJars.joined(pathComponents.subList(0, pathComponents.size() - 1));
    }

    @VisibleForTesting
    static Optional<String> joined(List<String> parts) {
        if (KiwiLists.isNullOrEmpty(parts)) {
            return Optional.empty();
        }
        return Optional.of(String.join((CharSequence)File.separator, parts));
    }

    public static Optional<String> readSingleValueFromJarManifest(String manifestEntryName) {
        return KiwiJars.readSingleValueFromJarManifest(KiwiJars.class.getClassLoader(), manifestEntryName, null);
    }

    public static Optional<String> readSingleValueFromJarManifest(ClassLoader classLoader, String manifestEntryName) {
        return KiwiJars.readSingleValueFromJarManifest(classLoader, manifestEntryName, null);
    }

    public static Optional<String> readSingleValueFromJarManifest(ClassLoader classLoader, String manifestEntryName, Predicate<URL> manifestFilter) {
        try {
            List<URL> urls;
            if (Objects.isNull(manifestFilter)) {
                Optional<URL> manifestUrl = Optional.ofNullable(classLoader.getResource("META-INF/MANIFEST.MF"));
                urls = manifestUrl.map(List::of).orElse(null);
            } else {
                Iterator<URL> urlIterator = classLoader.getResources("META-INF/MANIFEST.MF").asIterator();
                Iterable urlIterable = () -> urlIterator;
                urls = StreamSupport.stream(urlIterable.spliterator(), false).filter(manifestFilter).toList();
            }
            LOG.trace("Using manifest URL(s): {}", urls);
            if (KiwiLists.isNullOrEmpty(urls)) {
                return Optional.empty();
            }
            return urls.stream().map(url -> KiwiJars.readEntry(url, manifestEntryName)).flatMap(Optional::stream).findFirst();
        }
        catch (Exception e) {
            LOG.warn("Unable to locate {} from JAR", (Object)manifestEntryName, (Object)e);
            return Optional.empty();
        }
    }

    private static Optional<String> readEntry(URL url, String manifestEntryName) {
        Optional<String> optional;
        block8: {
            InputStream in = url.openStream();
            try {
                Manifest manifest = new Manifest(in);
                optional = KiwiJars.readEntry(manifest, manifestEntryName);
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LOG.warn("Unable to read manifest", (Throwable)e);
                    return Optional.empty();
                }
            }
            in.close();
        }
        return optional;
    }

    private static Optional<String> readEntry(Manifest manifest, String manifestEntryName) {
        return Optional.ofNullable(manifest.getMainAttributes().getValue(manifestEntryName));
    }

    public static Map<String, String> readValuesFromJarManifest(String ... manifestEntryNames) {
        return KiwiJars.readValuesFromJarManifest(KiwiJars.class.getClassLoader(), null, manifestEntryNames);
    }

    public static Map<String, String> readValuesFromJarManifest(ClassLoader classLoader, String ... manifestEntryNames) {
        return KiwiJars.readValuesFromJarManifest(classLoader, null, manifestEntryNames);
    }

    public static Map<String, String> readValuesFromJarManifest(ClassLoader classLoader, Predicate<URL> manifestFilter, String ... manifestEntryNames) {
        HashMap<String, String> entries = new HashMap<String, String>();
        Arrays.stream(manifestEntryNames).forEach(manifestEntryName -> {
            Optional<String> entry = KiwiJars.readSingleValueFromJarManifest(classLoader, manifestEntryName, manifestFilter);
            entry.ifPresent(value -> entries.put((String)manifestEntryName, (String)value));
        });
        return entries;
    }

    @Generated
    private KiwiJars() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

