/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.regex;

import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.kiwiproject.base.KiwiPreconditions;

public class MatchSpliterator
extends Spliterators.AbstractSpliterator<MatchResult> {
    private static final boolean PARALLEL_FALSE = false;
    private final Matcher matcher;

    public MatchSpliterator(Matcher matcher) {
        super(Long.MAX_VALUE, 272);
        this.matcher = KiwiPreconditions.requireNotNull(matcher);
    }

    @Override
    public boolean tryAdvance(Consumer<? super MatchResult> action) {
        if (this.matcher.find()) {
            action.accept(this.matcher.toMatchResult());
            return true;
        }
        return false;
    }

    public Stream<MatchResult> stream() {
        return MatchSpliterator.stream(this.matcher);
    }

    public static Stream<MatchResult> stream(String regex, String input) {
        KiwiPreconditions.checkArgumentNotBlank(regex);
        return MatchSpliterator.stream(Pattern.compile(regex), input);
    }

    public static Stream<MatchResult> stream(Pattern pattern, String input) {
        KiwiPreconditions.checkArgumentNotNull(pattern);
        return MatchSpliterator.stream(pattern.matcher(input));
    }

    public static Stream<MatchResult> stream(Matcher matcher) {
        KiwiPreconditions.checkArgumentNotNull(matcher);
        return StreamSupport.stream(new MatchSpliterator(matcher), false);
    }
}

