/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.security;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.net.ssl.SSLContext;
import lombok.Generated;
import org.kiwiproject.base.KiwiStrings;
import org.kiwiproject.collect.KiwiMaps;
import org.kiwiproject.security.KeyStoreType;
import org.kiwiproject.security.KiwiSecurity;
import org.kiwiproject.security.SSLContextException;

public class SimpleSSLContextFactory {
    @Generated
    private final Object $lock = new Object[0];
    private static final String KEY_STORE_PATH_PROPERTY = "keyStorePath";
    private static final String KEY_STORE_PASSWORD_PROPERTY = "keyStorePassword";
    private static final String KEY_STORE_TYPE_PROPERTY = "keyStoreType";
    private static final String TRUST_STORE_PATH_PROPERTY = "trustStorePath";
    private static final String TRUST_STORE_PASSWORD_PROPERTY = "trustStorePassword";
    private static final String TRUST_STORE_TYPE_PROPERTY = "trustStoreType";
    private static final String PROTOCOL_PROPERTY = "protocol";
    private static final String VERIFY_HOSTNAME_PROPERTY = "verifyHostname";
    private static final String DISABLE_SNI_HOST_CHECK_PROPERTY = "disableSniHostCheck";
    private static final List<String> REQUIRED_PROPERTIES = List.of("trustStorePath", "trustStorePassword", "protocol");
    private final String keyStorePath;
    private final String keyStorePassword;
    private final String keyStoreType;
    private final String trustStorePath;
    private final String trustStorePassword;
    private final String trustStoreType;
    private final String protocol;
    private SSLContext sslContext;
    private final boolean verifyHostname;
    private boolean disableSniHostCheck;

    public SimpleSSLContextFactory(String keyStorePath, String keyStorePassword, String trustStorePath, String trustStorePassword, String protocol) {
        this(keyStorePath, keyStorePassword, trustStorePath, trustStorePassword, protocol, true);
    }

    public SimpleSSLContextFactory(String keyStorePath, String keyStorePassword, String trustStorePath, String trustStorePassword, String protocol, boolean verifyHostname) {
        this(keyStorePath, keyStorePassword, KeyStoreType.JKS.value, trustStorePath, trustStorePassword, KeyStoreType.JKS.value, protocol, verifyHostname);
    }

    public SimpleSSLContextFactory(String keyStorePath, String keyStorePassword, String keyStoreType, String trustStorePath, String trustStorePassword, String trustStoreType, String protocol, boolean verifyHostname) {
        this.keyStorePath = keyStorePath;
        this.keyStorePassword = keyStorePassword;
        this.keyStoreType = keyStoreType;
        this.trustStorePath = trustStorePath;
        this.trustStorePassword = trustStorePassword;
        this.trustStoreType = trustStoreType;
        this.protocol = protocol;
        this.verifyHostname = verifyHostname;
    }

    public SimpleSSLContextFactory(String keyStorePath, String keyStorePassword, String keyStoreType, String trustStorePath, String trustStorePassword, String trustStoreType, String protocol, boolean verifyHostname, boolean disableSniHostCheck) {
        this.keyStorePath = keyStorePath;
        this.keyStorePassword = keyStorePassword;
        this.keyStoreType = keyStoreType;
        this.trustStorePath = trustStorePath;
        this.trustStorePassword = trustStorePassword;
        this.trustStoreType = trustStoreType;
        this.protocol = protocol;
        this.verifyHostname = verifyHostname;
        this.disableSniHostCheck = disableSniHostCheck;
    }

    public static Builder builder() {
        return new Builder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SSLContext getSslContext() {
        Object object = this.$lock;
        synchronized (object) {
            if (Objects.isNull(this.sslContext)) {
                this.sslContext = KiwiSecurity.createSslContext(this.keyStorePath, this.keyStorePassword, this.keyStoreType, this.trustStorePath, this.trustStorePassword, this.trustStoreType, this.protocol);
            }
            return this.sslContext;
        }
    }

    public Map<String, Object> configuration() {
        return Collections.unmodifiableMap(KiwiMaps.newHashMap(KEY_STORE_PATH_PROPERTY, this.keyStorePath, KEY_STORE_PASSWORD_PROPERTY, this.keyStorePassword, KEY_STORE_TYPE_PROPERTY, this.keyStoreType, TRUST_STORE_PATH_PROPERTY, this.trustStorePath, TRUST_STORE_PASSWORD_PROPERTY, this.trustStorePassword, TRUST_STORE_TYPE_PROPERTY, this.trustStoreType, PROTOCOL_PROPERTY, this.protocol, VERIFY_HOSTNAME_PROPERTY, this.verifyHostname, DISABLE_SNI_HOST_CHECK_PROPERTY, this.disableSniHostCheck));
    }

    @Generated
    public boolean isVerifyHostname() {
        return this.verifyHostname;
    }

    @Generated
    public boolean isDisableSniHostCheck() {
        return this.disableSniHostCheck;
    }

    public static class Builder {
        private final Map<String, Optional<String>> entries;

        protected Builder() {
            this.entries = KiwiMaps.newHashMap(SimpleSSLContextFactory.KEY_STORE_PATH_PROPERTY, Optional.empty(), SimpleSSLContextFactory.KEY_STORE_PASSWORD_PROPERTY, Optional.empty(), SimpleSSLContextFactory.KEY_STORE_TYPE_PROPERTY, Optional.of(KeyStoreType.JKS.value), SimpleSSLContextFactory.TRUST_STORE_PATH_PROPERTY, Optional.empty(), SimpleSSLContextFactory.TRUST_STORE_PASSWORD_PROPERTY, Optional.empty(), SimpleSSLContextFactory.TRUST_STORE_TYPE_PROPERTY, Optional.of(KeyStoreType.JKS.value), SimpleSSLContextFactory.PROTOCOL_PROPERTY, Optional.empty(), SimpleSSLContextFactory.VERIFY_HOSTNAME_PROPERTY, Optional.of("true"), SimpleSSLContextFactory.DISABLE_SNI_HOST_CHECK_PROPERTY, Optional.of("false"));
        }

        public Builder keyStorePath(String keyStorePath) {
            return this.setKeyStorePath(keyStorePath);
        }

        public Builder setKeyStorePath(String keyStorePath) {
            this.entries.put(SimpleSSLContextFactory.KEY_STORE_PATH_PROPERTY, Optional.of(keyStorePath));
            return this;
        }

        public Builder keyStorePassword(String keyStorePassword) {
            return this.setKeyStorePassword(keyStorePassword);
        }

        public Builder setKeyStorePassword(String keyStorePassword) {
            this.entries.put(SimpleSSLContextFactory.KEY_STORE_PASSWORD_PROPERTY, Optional.of(keyStorePassword));
            return this;
        }

        public Builder keyStoreType(String keyStoreType) {
            return this.setKeyStoreType(keyStoreType);
        }

        public Builder setKeyStoreType(String keyStoreType) {
            this.entries.put(SimpleSSLContextFactory.KEY_STORE_TYPE_PROPERTY, Optional.of(keyStoreType));
            return this;
        }

        public Builder trustStorePath(String trustStorePath) {
            return this.setTrustStorePath(trustStorePath);
        }

        public Builder setTrustStorePath(String trustStorePath) {
            this.entries.put(SimpleSSLContextFactory.TRUST_STORE_PATH_PROPERTY, Optional.of(trustStorePath));
            return this;
        }

        public Builder trustStorePassword(String trustStorePassword) {
            return this.setTrustStorePassword(trustStorePassword);
        }

        public Builder setTrustStorePassword(String trustStorePassword) {
            this.entries.put(SimpleSSLContextFactory.TRUST_STORE_PASSWORD_PROPERTY, Optional.of(trustStorePassword));
            return this;
        }

        public Builder trustStoreType(String trustStoreType) {
            return this.setTrustStoreType(trustStoreType);
        }

        public Builder setTrustStoreType(String trustStoreType) {
            this.entries.put(SimpleSSLContextFactory.TRUST_STORE_TYPE_PROPERTY, Optional.of(trustStoreType));
            return this;
        }

        public Builder protocol(String protocol) {
            return this.setProtocol(protocol);
        }

        public Builder setProtocol(String protocol) {
            this.entries.put(SimpleSSLContextFactory.PROTOCOL_PROPERTY, Optional.of(protocol));
            return this;
        }

        public Builder verifyHostname(boolean verifyHostname) {
            return this.setVerifyHostname(verifyHostname);
        }

        public Builder setVerifyHostname(boolean verifyHostname) {
            this.entries.put(SimpleSSLContextFactory.VERIFY_HOSTNAME_PROPERTY, Builder.optionalStringOf(verifyHostname));
            return this;
        }

        public Builder disableSniHostCheck(boolean disableSniHostCheck) {
            return this.setDisableSniHostCheck(disableSniHostCheck);
        }

        public Builder setDisableSniHostCheck(boolean disableSniHostCheck) {
            this.entries.put(SimpleSSLContextFactory.DISABLE_SNI_HOST_CHECK_PROPERTY, Builder.optionalStringOf(disableSniHostCheck));
            return this;
        }

        private static Optional<String> optionalStringOf(boolean value) {
            return Optional.of(String.valueOf(value));
        }

        public SimpleSSLContextFactory build() {
            this.validateBuilderState();
            return new SimpleSSLContextFactory(this.stringOrNull(SimpleSSLContextFactory.KEY_STORE_PATH_PROPERTY), this.stringOrNull(SimpleSSLContextFactory.KEY_STORE_PASSWORD_PROPERTY), this.stringOrThrow(SimpleSSLContextFactory.KEY_STORE_TYPE_PROPERTY), this.stringOrThrow(SimpleSSLContextFactory.TRUST_STORE_PATH_PROPERTY), this.stringOrThrow(SimpleSSLContextFactory.TRUST_STORE_PASSWORD_PROPERTY), this.stringOrThrow(SimpleSSLContextFactory.TRUST_STORE_TYPE_PROPERTY), this.stringOrThrow(SimpleSSLContextFactory.PROTOCOL_PROPERTY), this.toBooleanOrThrow(SimpleSSLContextFactory.VERIFY_HOSTNAME_PROPERTY), this.toBooleanOrThrow(SimpleSSLContextFactory.DISABLE_SNI_HOST_CHECK_PROPERTY));
        }

        public void validateBuilderState() {
            this.entries.entrySet().stream().filter(entry -> ((Optional)entry.getValue()).isEmpty()).filter(entry -> REQUIRED_PROPERTIES.contains(entry.getKey())).findAny().ifPresent(entry -> Builder.throwBuildException((String)entry.getKey()));
        }

        private String stringOrNull(String propertyName) {
            return this.entries.get(propertyName).orElse(null);
        }

        private String stringOrThrow(String propertyName) {
            return this.entries.get(propertyName).orElseThrow(IllegalStateException::new);
        }

        private boolean toBooleanOrThrow(String propertyName) {
            String boolString = this.entries.get(propertyName).orElseThrow(IllegalStateException::new);
            return Boolean.parseBoolean(boolString);
        }

        private static void throwBuildException(String property) {
            throw new SSLContextException(KiwiStrings.f("Required property '{}' not set; cannot build SimpleSSLContextFactory", property));
        }
    }
}

