/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.validation;

import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import java.io.File;
import java.nio.file.Path;
import java.util.Objects;
import lombok.Generated;
import org.kiwiproject.validation.FilePath;
import org.kiwiproject.validation.InternalKiwiValidators;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilePathValidator
implements ConstraintValidator<FilePath, String> {
    @Generated
    private static final Logger LOG = LoggerFactory.getLogger(FilePathValidator.class);
    private FilePath filePath;

    public void initialize(FilePath constraintAnnotation) {
        this.filePath = constraintAnnotation;
    }

    public boolean isValid(String value, ConstraintValidatorContext context) {
        if (Objects.isNull(value)) {
            return this.filePath.allowNull();
        }
        try {
            File file = Path.of(value, new String[0]).toFile();
            return file.exists() && file.isFile();
        }
        catch (Exception e) {
            String nulCharacterMessage = InternalKiwiValidators.containsNulCharacter(value) ? " Path contains Nul character!" : "";
            LOG.warn("Exception thrown validating path.{}", (Object)nulCharacterMessage, (Object)e);
            return false;
        }
    }
}

