/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.io;

import com.google.common.base.Preconditions;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.kiwiproject.base.KiwiPreconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KiwiIO {
    @Generated
    private static final Logger LOG = LoggerFactory.getLogger(KiwiIO.class);
    private static final List<String> DEFAULT_CLOSE_METHOD_NAMES = List.of("close", "stop", "shutdown", "shutdownNow");

    public static void closeQuietly(Closeable closeable) {
        try {
            if (Objects.nonNull(closeable)) {
                closeable.close();
            }
        }
        catch (IOException ioe) {
            KiwiIO.logCloseError(closeable.getClass(), ioe);
        }
    }

    public static void closeQuietly(Closeable ... closeables) {
        if (Objects.isNull(closeables)) {
            return;
        }
        for (Closeable closeable : closeables) {
            KiwiIO.closeQuietly(closeable);
        }
    }

    public static void closeQuietly(XMLStreamReader xmlStreamReader) {
        if (Objects.nonNull(xmlStreamReader)) {
            try {
                xmlStreamReader.close();
            }
            catch (Exception e) {
                KiwiIO.logCloseError(XMLStreamReader.class, e);
            }
        }
    }

    public static void closeQuietly(XMLStreamWriter xmlStreamWriter) {
        if (Objects.nonNull(xmlStreamWriter)) {
            try {
                xmlStreamWriter.close();
            }
            catch (Exception e) {
                KiwiIO.logCloseError(XMLStreamWriter.class, e);
            }
        }
    }

    public static List<String> defaultCloseMethodNames() {
        return DEFAULT_CLOSE_METHOD_NAMES;
    }

    public static void closeObjectQuietly(Object object) {
        if (Objects.isNull(object)) {
            return;
        }
        CloseableResource closeableResource = KiwiIO.asCloseableResource(object);
        KiwiIO.closeResourceQuietly(closeableResource);
    }

    public static void closeObjectQuietly(String closeMethodName, Object object) {
        KiwiPreconditions.checkArgumentNotBlank(closeMethodName, "closeMethodName must not be blank");
        KiwiPreconditions.checkArgumentNotInstanceOf(object, CloseableResource.class, "object must not be a CloseableResource");
        KiwiIO.closeResourceQuietly(new CloseableResource(object, List.of(closeMethodName)));
    }

    public static void closeObjectsQuietly(Object ... objects) {
        if (Objects.isNull(objects)) {
            return;
        }
        Arrays.stream(objects).filter(Objects::nonNull).map(KiwiIO::asCloseableResource).forEach(KiwiIO::closeResourceQuietly);
    }

    private static CloseableResource asCloseableResource(Object object) {
        CloseableResource closeableResource;
        return object instanceof CloseableResource ? (closeableResource = (CloseableResource)object) : new CloseableResource(object, DEFAULT_CLOSE_METHOD_NAMES);
    }

    public static void closeObjectsQuietly(String closeMethodName, Object ... objects) {
        if (Objects.isNull(objects)) {
            return;
        }
        KiwiIO.checkDoesNotContainAnyCloseableResources(closeMethodName, objects);
        Arrays.stream(objects).filter(Objects::nonNull).map(object -> new CloseableResource(object, List.of(closeMethodName))).forEach(KiwiIO::closeResourceQuietly);
    }

    private static void checkDoesNotContainAnyCloseableResources(String closeMethodName, Object ... objects) {
        for (Object object : objects) {
            KiwiIO.checkIsNotCloseableResource(closeMethodName, object);
        }
    }

    private static void checkIsNotCloseableResource(String closeMethodName, Object object) {
        Preconditions.checkArgument((boolean)KiwiIO.isNotCloseableResource(object), (String)"objects should not contain any instances of CloseableResource when a single closeMethodName (%s) is specified", (Object)closeMethodName);
    }

    private static boolean isNotCloseableResource(Object object) {
        return !(object instanceof CloseableResource);
    }

    public static void closeResourceQuietly(CloseableResource closeableResource) {
        KiwiPreconditions.checkArgumentNotNull(closeableResource, "closeableResource must not be null");
        List<String> closeMethodNames = closeableResource.closeMethodNames();
        KiwiPreconditions.checkArgumentNotEmpty(closeMethodNames, "closeMethodNames must not be empty");
        Object object = closeableResource.object();
        if (Objects.isNull(object)) {
            return;
        }
        Class<?> objectType = object.getClass();
        String typeName = objectType.getName();
        closeMethodNames.stream().map(methodName -> KiwiIO.tryClose(object, objectType, typeName, methodName)).filter(CloseResult::succeeded).findFirst().ifPresentOrElse(successResult -> LOG.trace("Successfully closed a {} using {}", (Object)typeName, (Object)successResult.methodName()), () -> LOG.warn("All attempts to close a {} failed. Tried using methods: {}", (Object)typeName, (Object)closeMethodNames));
    }

    private static CloseResult tryClose(Object object, Class<?> objectType, String typeName, String closeMethodName) {
        try {
            LOG.trace("Attempting to close a {} using {}", (Object)typeName, (Object)closeMethodName);
            MethodHandle methodHandle = MethodHandles.lookup().findVirtual(objectType, closeMethodName, MethodType.methodType(Void.TYPE));
            methodHandle.invoke(object);
            return new CloseResult(true, closeMethodName, null);
        }
        catch (Throwable error) {
            LOG.trace("Unable to close a {} using {}", new Object[]{typeName, closeMethodName, error});
            return new CloseResult(false, closeMethodName, error);
        }
    }

    private static void logCloseError(Class<?> typeOfObject, Throwable error) {
        LOG.warn("Unexpected error while attempting to close {} quietly (use DEBUG-level for stack trace): {}", (Object)typeOfObject.getSimpleName(), (Object)error.getMessage());
        LOG.debug("Error closing {} instance", (Object)typeOfObject.getName(), (Object)error);
    }

    public static ByteArrayInputStream newByteArrayInputStreamOfLines(String ... lines) {
        if (lines.length == 0) {
            return KiwiIO.emptyByteArrayInputStream();
        }
        String joined = Arrays.stream(lines).collect(Collectors.joining(System.lineSeparator()));
        byte[] buffer = joined.getBytes(StandardCharsets.UTF_8);
        return new ByteArrayInputStream(buffer);
    }

    public static ByteArrayInputStream newByteArrayInputStream(String value) {
        return KiwiIO.newByteArrayInputStream(value, StandardCharsets.UTF_8);
    }

    public static ByteArrayInputStream newByteArrayInputStream(String value, Charset charset) {
        KiwiPreconditions.checkArgumentNotNull(value, "value must not be null");
        KiwiPreconditions.checkArgumentNotNull(charset, "charset must not be null");
        byte[] bytes = value.getBytes(charset);
        return new ByteArrayInputStream(bytes);
    }

    public static ByteArrayInputStream emptyByteArrayInputStream() {
        return new ByteArrayInputStream(new byte[0]);
    }

    public static List<String> readLinesFromErrorStreamOf(Process process) {
        return KiwiIO.readLinesFrom(process.getErrorStream(), StandardCharsets.UTF_8);
    }

    public static List<String> readLinesFromErrorStreamOf(Process process, Charset charset) {
        return KiwiIO.readLinesFrom(process.getErrorStream(), charset);
    }

    public static List<String> readLinesFromInputStreamOf(Process process) {
        return KiwiIO.readLinesFrom(process.getInputStream(), StandardCharsets.UTF_8);
    }

    public static List<String> readLinesFromInputStreamOf(Process process, Charset charset) {
        return KiwiIO.readLinesFrom(process.getInputStream(), charset);
    }

    public static List<String> readLinesFrom(InputStream stream, Charset charset) {
        return KiwiIO.streamLinesFrom(stream, charset).toList();
    }

    public static Stream<String> streamLinesFromErrorStreamOf(Process process) {
        return KiwiIO.streamLinesFrom(process.getErrorStream(), StandardCharsets.UTF_8);
    }

    public static Stream<String> streamLinesFromErrorStreamOf(Process process, Charset charset) {
        return KiwiIO.streamLinesFrom(process.getErrorStream(), charset);
    }

    public static Stream<String> streamLinesFromInputStreamOf(Process process) {
        return KiwiIO.streamLinesFrom(process.getInputStream(), StandardCharsets.UTF_8);
    }

    public static Stream<String> streamLinesFromInputStreamOf(Process process, Charset charset) {
        return KiwiIO.streamLinesFrom(process.getInputStream(), charset);
    }

    public static Stream<String> streamLinesFrom(InputStream stream, Charset charset) {
        return new BufferedReader(new InputStreamReader(stream, charset)).lines();
    }

    public static String readInputStreamOf(Process process) {
        return KiwiIO.readInputStreamOf(process, StandardCharsets.UTF_8);
    }

    public static String readInputStreamOf(Process process, Charset charset) {
        return KiwiIO.readInputStreamAsString(process.getInputStream(), charset);
    }

    public static String readErrorStreamOf(Process process) {
        return KiwiIO.readErrorStreamOf(process, StandardCharsets.UTF_8);
    }

    public static String readErrorStreamOf(Process process, Charset charset) {
        return KiwiIO.readInputStreamAsString(process.getErrorStream(), charset);
    }

    public static String readInputStreamAsString(InputStream inputStream) {
        return KiwiIO.readInputStreamAsString(inputStream, StandardCharsets.UTF_8);
    }

    public static String readInputStreamAsString(InputStream inputStream, Charset charset) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            inputStream.transferTo(outputStream);
            return outputStream.toString(charset);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Error converting InputStream to String using Charset " + charset, e);
        }
    }

    @Generated
    private KiwiIO() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public record CloseableResource(@Nullable Object object, List<String> closeMethodNames) {
        public CloseableResource(@Nullable Object object, List<String> closeMethodNames) {
            KiwiPreconditions.checkArgumentContainsOnlyNotBlank(closeMethodNames, "closeMethodNames must not be null or empty, or contain any blanks");
        }

        public CloseableResource(@Nullable Object object) {
            this(object, DEFAULT_CLOSE_METHOD_NAMES);
        }

        public CloseableResource(@Nullable Object object, String closeMethodName) {
            this(object, List.of(KiwiPreconditions.requireNotBlank(closeMethodName, "closeMethodName must not be blank")));
        }
    }

    private record CloseResult(boolean succeeded, String methodName, Throwable error) {
    }
}

