/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import lombok.Generated;
import org.kiwiproject.json.PropertyMaskingOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyMaskingSafePropertyWriter
extends BeanPropertyWriter {
    @Generated
    private static final Logger LOG = LoggerFactory.getLogger(PropertyMaskingSafePropertyWriter.class);
    private final List<Pattern> hiddenFieldPatterns;
    private final String maskedFieldReplacementText;
    private final String serializationErrorReplacementText;

    public PropertyMaskingSafePropertyWriter(BeanPropertyWriter base, List<String> maskedFieldRegexps) {
        this(base, PropertyMaskingOptions.builder().maskedFieldRegexps(maskedFieldRegexps).build());
    }

    public PropertyMaskingSafePropertyWriter(BeanPropertyWriter base, PropertyMaskingOptions options) {
        super(base);
        this.hiddenFieldPatterns = PropertyMaskingSafePropertyWriter.convertToPatterns(options.getMaskedFieldRegexps());
        this.maskedFieldReplacementText = options.getMaskedFieldReplacementText();
        this.serializationErrorReplacementText = options.getSerializationErrorReplacementText();
    }

    private static List<Pattern> convertToPatterns(List<String> maskedFieldRegexps) {
        return maskedFieldRegexps.stream().filter(Objects::nonNull).map(regex -> Pattern.compile(regex, 2)).toList();
    }

    public void serializeAsField(Object bean, JsonGenerator gen, SerializerProvider prov) {
        String propertyName = this.getName();
        try {
            LOG.trace("Using custom serializer for field: {}", (Object)propertyName);
            if (this.matchesExclusionPatterns(propertyName)) {
                PropertyMaskingSafePropertyWriter.writeReplacementText(gen, propertyName, this.maskedFieldReplacementText);
            } else {
                super.serializeAsField(bean, gen, prov);
            }
        }
        catch (Exception e) {
            LOG.debug("Unable to serialize: {}, of {} instance, exception {}: {}", new Object[]{propertyName, bean.getClass().getName(), e.getClass().getName(), e.getMessage()});
            LOG.trace("Exception serializing field: {}", (Object)propertyName, (Object)e);
            PropertyMaskingSafePropertyWriter.writeReplacementText(gen, propertyName, this.serializationErrorReplacementText);
        }
    }

    private boolean matchesExclusionPatterns(String name) {
        return this.hiddenFieldPatterns.stream().anyMatch(pattern -> pattern.matcher(name).find());
    }

    @VisibleForTesting
    static void writeReplacementText(JsonGenerator gen, String name, String text) {
        LOG.trace("Setting field '{}' to: {}", (Object)name, (Object)text);
        try {
            gen.writeFieldName(name);
            gen.writeString(text);
        }
        catch (Exception e) {
            LOG.error("Failed to serialize replacement value for field: {}", (Object)name, (Object)e);
        }
    }
}

