/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.search;

import com.google.common.base.Preconditions;
import lombok.Generated;
import org.kiwiproject.base.KiwiPreconditions;

public final class KiwiSearching {
    public static final int DEFAULT_PAGE_SIZE = 25;
    public static final String DEFAULT_PAGE_SIZE_AS_STRING = "25";
    public static final String PAGE_SIZE_ERROR = "pageSize must be at least 1";

    public static void checkPageSize(int pageSize) {
        Preconditions.checkArgument((pageSize > 0 ? 1 : 0) != 0, (Object)PAGE_SIZE_ERROR);
    }

    public static void checkPageNumber(int pageNumber) {
        PageNumberingScheme.ONE_BASED.checkPageNumber(pageNumber);
    }

    public static void checkPageNumber(int pageNumber, PageNumberingScheme numberingScheme) {
        KiwiPreconditions.checkArgumentNotNull(numberingScheme);
        numberingScheme.checkPageNumber(pageNumber);
    }

    public static int zeroBasedOffset(int pageNumber, int pageSize) {
        return KiwiSearching.zeroBasedOffset(pageNumber, PageNumberingScheme.ONE_BASED, pageSize);
    }

    public static int zeroBasedOffsetForOneBasedPaging(int pageNumber, int pageSize) {
        return KiwiSearching.zeroBasedOffset(pageNumber, pageSize);
    }

    public static int zeroBasedOffsetForZeroBasedPaging(int pageNumber, int pageSize) {
        return KiwiSearching.zeroBasedOffset(pageNumber, PageNumberingScheme.ZERO_BASED, pageSize);
    }

    public static int zeroBasedOffset(int pageNumber, PageNumberingScheme numberingScheme, int pageSize) {
        KiwiSearching.checkPageNumber(pageNumber, numberingScheme);
        KiwiSearching.checkPageSize(pageSize);
        return (pageNumber - numberingScheme.minimumPageNumber) * pageSize;
    }

    public static int numberOfPages(long resultCount, int pageSize) {
        KiwiSearching.checkPageSize(pageSize);
        return (int)(resultCount / (long)pageSize) + (resultCount % (long)pageSize > 0L ? 1 : 0);
    }

    public static int numberOnPage(long resultCount, int pageSize, int pageNumber) {
        return KiwiSearching.numberOnPage(resultCount, pageSize, pageNumber, PageNumberingScheme.ONE_BASED);
    }

    public static int numberOnPage(long resultCount, int pageSize, int pageNumber, PageNumberingScheme numberingScheme) {
        int schemePageNumber;
        KiwiSearching.checkPageNumber(pageNumber, numberingScheme);
        KiwiSearching.checkPageSize(pageSize);
        if (resultCount == 0L) {
            return 0;
        }
        int numPages = KiwiSearching.numberOfPages(resultCount, pageSize);
        int n = schemePageNumber = numberingScheme == PageNumberingScheme.ONE_BASED ? pageNumber : pageNumber + 1;
        if (schemePageNumber > numPages) {
            return 0;
        }
        if (schemePageNumber == numPages) {
            long remainder = resultCount % (long)pageSize;
            return remainder == 0L ? pageSize : (int)remainder;
        }
        return pageSize;
    }

    @Generated
    private KiwiSearching() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static enum PageNumberingScheme {
        ZERO_BASED("pageNumber starts at 0", 0),
        ONE_BASED("pageNumber starts at 1", 1);

        public final String pageNumberError;
        public final int minimumPageNumber;

        private PageNumberingScheme(String pageNumberError, int minimumPageNumber) {
            this.pageNumberError = pageNumberError;
            this.minimumPageNumber = minimumPageNumber;
        }

        public void checkPageNumber(int pageNumber) {
            Preconditions.checkArgument((pageNumber >= this.minimumPageNumber ? 1 : 0) != 0, (Object)this.pageNumberError);
        }

        @Generated
        public String getPageNumberError() {
            return this.pageNumberError;
        }

        @Generated
        public int getMinimumPageNumber() {
            return this.minimumPageNumber;
        }
    }
}

