/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.validation;

import com.google.common.base.Strings;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.kiwiproject.base.KiwiStrings;
import org.kiwiproject.collect.KiwiLists;
import org.kiwiproject.validation.InEnum;
import org.kiwiproject.validation.KiwiValidations;

public class InEnumValidator
implements ConstraintValidator<InEnum, String> {
    private InEnum inEnum;
    private List<String> allowableValues;
    private String errorMessage;

    public void initialize(InEnum constraintAnnotation) {
        this.inEnum = constraintAnnotation;
        List<Enum<?>> constants = List.of(this.inEnum.enumClass().getEnumConstants());
        this.allowableValues = constants.stream().map(anEnum -> this.enumConstantOrStringValue(this.inEnum, (Enum<?>)anEnum)).map(stringValue -> this.uppercaseIfIgnoringCase(this.inEnum, (String)stringValue)).toList();
        this.checkAllowableValuesExist();
        this.errorMessage = this.inEnum.message() + " " + this.allowableValues;
    }

    private String enumConstantOrStringValue(InEnum inEnum, Enum<?> enumValue) {
        String valueMethod = inEnum.valueMethod();
        if (StringUtils.isBlank((CharSequence)valueMethod)) {
            return enumValue.name();
        }
        Class<?> enumClass = enumValue.getClass();
        try {
            Method method = enumClass.getDeclaredMethod(valueMethod, new Class[0]);
            return String.valueOf(method.invoke(enumValue, new Object[0]));
        }
        catch (Exception e) {
            String message = KiwiStrings.f("Unable to invoke valueMethod '{}' on class {}. Is it a public no-arg method?", valueMethod, enumClass.getName());
            throw new IllegalStateException(message);
        }
    }

    private String uppercaseIfIgnoringCase(InEnum inEnum, String value) {
        if (inEnum.ignoreCase()) {
            return this.uppercase(value);
        }
        return value;
    }

    private String uppercase(String value) {
        return Strings.nullToEmpty((String)value).toUpperCase(Locale.getDefault());
    }

    public boolean isValid(String value, ConstraintValidatorContext context) {
        this.checkAllowableValuesExist();
        if (Objects.isNull(value)) {
            if (this.inEnum.allowNull()) {
                return true;
            }
            KiwiValidations.addError(context, this.errorMessage);
            return false;
        }
        String nonNullValue = this.valueToCompare(value);
        if (this.allowableValues.contains(nonNullValue)) {
            return true;
        }
        KiwiValidations.addError(context, this.errorMessage);
        return false;
    }

    private void checkAllowableValuesExist() {
        if (KiwiLists.isNullOrEmpty(this.allowableValues)) {
            String message = KiwiStrings.f("Enum {} has no values to validate against!", this.inEnum.enumClass().getSimpleName());
            throw new IllegalStateException(message);
        }
    }

    private String valueToCompare(String value) {
        Objects.requireNonNull(value);
        return this.inEnum.ignoreCase() ? this.uppercase(value) : value;
    }
}

