/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.validation;

import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import java.util.Objects;
import org.kiwiproject.validation.LongValue;

public class LongValueValidator
implements ConstraintValidator<LongValue, CharSequence> {
    private LongValue longValue;

    public void initialize(LongValue constraintAnnotation) {
        this.longValue = constraintAnnotation;
    }

    public boolean isValid(CharSequence value, ConstraintValidatorContext context) {
        if (Objects.isNull(value)) {
            return this.longValue.allowNull();
        }
        try {
            Long.parseLong(value.toString());
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

