/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.base;

import com.google.common.base.Enums;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.EnumUtils;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.kiwiproject.base.KiwiPreconditions;
import org.kiwiproject.collect.KiwiArrays;

public final class KiwiEnums {
    public static <E extends Enum<E>> Optional<E> getIfPresent(Class<E> enumClass, @Nullable String value) {
        KiwiPreconditions.checkArgumentNotNull(enumClass);
        if (StringUtils.isBlank((CharSequence)value)) {
            return Optional.empty();
        }
        return Enums.getIfPresent(enumClass, (String)value).toJavaUtil();
    }

    public static <E extends Enum<E>> Optional<E> getIfPresentIgnoreCase(Class<E> enumClass, @Nullable String value) {
        KiwiPreconditions.checkArgumentNotNull(enumClass);
        if (StringUtils.isBlank((CharSequence)value)) {
            return Optional.empty();
        }
        return Optional.ofNullable(EnumUtils.getEnumIgnoreCase(enumClass, (String)value)).or(() -> Optional.ofNullable(EnumUtils.getEnumIgnoreCase((Class)enumClass, (String)value.strip())));
    }

    public static <E extends Enum<E>> boolean equals(Enum<E> enumValue, @Nullable CharSequence value) {
        KiwiEnums.checkEnumNotNull(enumValue);
        return enumValue.name().equals(KiwiEnums.stringOrNull(value));
    }

    public static <E extends Enum<E>> boolean equalsIgnoreCase(Enum<E> enumValue, @Nullable CharSequence value) {
        KiwiEnums.checkEnumNotNull(enumValue);
        return enumValue.name().equalsIgnoreCase(KiwiEnums.stringOrNull(value));
    }

    public static <E extends Enum<E>> boolean notEquals(Enum<E> enumValue, @Nullable CharSequence value) {
        return !KiwiEnums.equals(enumValue, value);
    }

    public static <E extends Enum<E>> boolean notEqualsIgnoreCase(Enum<E> enumValue, @Nullable CharSequence value) {
        return !KiwiEnums.equalsIgnoreCase(enumValue, value);
    }

    @SafeVarargs
    public static <E extends Enum<E>> boolean equalsAny(@Nullable CharSequence value, Enum<E> ... enumValues) {
        KiwiEnums.checkEnumsNotNullOrEmpty(enumValues);
        return Arrays.stream(enumValues).anyMatch(enumValue -> KiwiEnums.equals(enumValue, KiwiEnums.stringOrNull(value)));
    }

    @SafeVarargs
    public static <E extends Enum<E>> boolean equalsAnyIgnoreCase(@Nullable CharSequence value, Enum<E> ... enumValues) {
        KiwiEnums.checkEnumsNotNullOrEmpty(enumValues);
        return Arrays.stream(enumValues).anyMatch(enumValue -> KiwiEnums.equalsIgnoreCase(enumValue, KiwiEnums.stringOrNull(value)));
    }

    private static String stringOrNull(@Nullable CharSequence value) {
        return Objects.isNull(value) ? null : value.toString();
    }

    @SafeVarargs
    private static <E extends Enum<E>> void checkEnumsNotNullOrEmpty(Enum<E> ... enumValues) {
        Preconditions.checkArgument((boolean)KiwiArrays.isNotNullOrEmpty(enumValues), (Object)"enumValues must not be null or empty");
    }

    public static <E extends Enum<E>> String lowercaseName(Enum<E> enumValue) {
        return KiwiEnums.lowercaseName(enumValue, Locale.ENGLISH);
    }

    public static <E extends Enum<E>> String lowercaseName(Enum<E> enumValue, Locale locale) {
        KiwiEnums.checkEnumNotNull(enumValue);
        return enumValue.name().toLowerCase(locale);
    }

    private static <E extends Enum<E>> void checkEnumNotNull(Enum<E> enumValue) {
        KiwiPreconditions.checkArgumentNotNull(enumValue, "enumValue must not be null");
    }

    @Generated
    private KiwiEnums() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

