/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.dropwizard.jdbi3;

import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class Jdbi3Helpers {
    @Generated
    private static final Logger LOG = LoggerFactory.getLogger(Jdbi3Helpers.class);

    static Optional<JdbiPlugin> getPluginInstance(String pluginClassName) {
        Pair<Boolean, Class<?>> result = Jdbi3Helpers.isPluginAvailable(pluginClassName);
        if (BooleanUtils.isTrue((Boolean)((Boolean)result.getLeft()))) {
            try {
                Class pluginClass = (Class)result.getRight();
                JdbiPlugin pluginInstance = (JdbiPlugin)pluginClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                return Optional.of(pluginInstance);
            }
            catch (Exception e) {
                LOG.warn("Error instantiating plugin for class: {}", (Object)pluginClassName);
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    private static Pair<Boolean, Class<?>> isPluginAvailable(String pluginClassName) {
        try {
            Class<?> pluginClass = Class.forName(pluginClassName);
            return Pair.of((Object)true, pluginClass);
        }
        catch (ClassNotFoundException e) {
            return Pair.of((Object)false, null);
        }
    }

    @Generated
    private Jdbi3Helpers() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

