/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.retry;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.kiwiproject.base.UUIDs;
import org.kiwiproject.collect.KiwiLists;

public class RetryResult<T> {
    private final String resultUuid;
    private final int numAttemptsMade;
    private final int maxAttempts;
    private final T object;
    private final List<Exception> errors;

    public RetryResult(int numAttemptsMade, int maxAttempts, @Nullable T object, @Nullable List<Exception> errors) {
        Preconditions.checkArgument((numAttemptsMade <= maxAttempts ? 1 : 0) != 0, (String)"numAttemptsMade (%s) is not less or equal to maxAttempts (%s)", (int)numAttemptsMade, (int)maxAttempts);
        this.resultUuid = UUIDs.randomUUIDString();
        this.numAttemptsMade = numAttemptsMade;
        this.maxAttempts = maxAttempts;
        this.object = object;
        this.errors = KiwiLists.isNullOrEmpty(errors) ? List.of() : List.copyOf(errors);
    }

    public boolean succeeded() {
        return this.hasObject();
    }

    public boolean failed() {
        return !this.succeeded();
    }

    public boolean hasObject() {
        return Objects.nonNull(this.object);
    }

    public T getObject() {
        return this.getObjectIfPresent().orElseThrow(() -> new IllegalStateException("No object is present in this result"));
    }

    public Optional<T> getObjectIfPresent() {
        return Optional.ofNullable(this.object);
    }

    public boolean hasMoreThanOneAttempt() {
        return this.getNumAttemptsMade() > 1;
    }

    public boolean hasAnyErrors() {
        return !this.errors.isEmpty();
    }

    public int getNumErrors() {
        return this.errors.size();
    }

    public Exception getLastError() {
        return this.getLastErrorIfPresent().orElseThrow(() -> new IllegalStateException("No errors exist in this result"));
    }

    public Optional<Exception> getLastErrorIfPresent() {
        return this.errors.isEmpty() ? Optional.empty() : Optional.of(KiwiLists.last(this.errors));
    }

    public Set<String> getUniqueErrorTypes() {
        return this.errors.stream().map(e -> e.getClass().getName()).collect(Collectors.toUnmodifiableSet());
    }

    @Generated
    public String getResultUuid() {
        return this.resultUuid;
    }

    @Generated
    public int getNumAttemptsMade() {
        return this.numAttemptsMade;
    }

    @Generated
    public int getMaxAttempts() {
        return this.maxAttempts;
    }

    @Generated
    public List<Exception> getErrors() {
        return this.errors;
    }
}

