/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.retry;

import com.google.common.annotations.VisibleForTesting;
import java.beans.ConstructorProperties;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import lombok.Generated;
import org.kiwiproject.base.DefaultEnvironment;
import org.kiwiproject.base.KiwiEnvironment;
import org.kiwiproject.retry.RetryResult;
import org.kiwiproject.retry.SimpleRetries;
import org.slf4j.event.Level;

public class SimpleRetryer {
    public static final int DEFAULT_MAX_ATTEMPTS = 3;
    public static final long DEFAULT_RETRY_DELAY_TIME = 50L;
    public static final TimeUnit DEFAULT_RETRY_DELAY_UNIT = TimeUnit.MILLISECONDS;
    public static final String DEFAULT_TYPE = "object";
    public static final Level DEFAULT_RETRY_LOG_LEVEL = Level.TRACE;
    @VisibleForTesting
    final KiwiEnvironment environment;
    @VisibleForTesting
    final int maxAttempts;
    @VisibleForTesting
    final long retryDelayTime;
    @VisibleForTesting
    final TimeUnit retryDelayUnit;
    @VisibleForTesting
    final String commonType;
    @VisibleForTesting
    final Level logLevelForSubsequentAttempts;

    public <T> Optional<T> tryGetObject(Supplier<T> supplier) {
        return this.tryGetObject(this.commonType, supplier);
    }

    public <T> Optional<T> tryGetObject(Class<T> type, Supplier<T> supplier) {
        return this.tryGetObject(type.getSimpleName(), supplier);
    }

    public <T> Optional<T> tryGetObject(String type, Supplier<T> supplier) {
        return SimpleRetries.tryGetObject(this.maxAttempts, this.retryDelayTime, this.retryDelayUnit, this.environment, type, this.logLevelForSubsequentAttempts, supplier);
    }

    public <T> RetryResult<T> tryGetObjectCollectingErrors(Supplier<T> supplier) {
        return this.tryGetObjectCollectingErrors(this.commonType, supplier);
    }

    public <T> RetryResult<T> tryGetObjectCollectingErrors(Class<T> type, Supplier<T> supplier) {
        return this.tryGetObjectCollectingErrors(type.getSimpleName(), supplier);
    }

    public <T> RetryResult<T> tryGetObjectCollectingErrors(String type, Supplier<T> supplier) {
        return SimpleRetries.tryGetObjectCollectingErrors(this.maxAttempts, this.retryDelayTime, this.retryDelayUnit, this.environment, type, supplier);
    }

    @Generated
    private static KiwiEnvironment $default$environment() {
        return new DefaultEnvironment();
    }

    @Generated
    private static int $default$maxAttempts() {
        return 3;
    }

    @Generated
    private static long $default$retryDelayTime() {
        return 50L;
    }

    @Generated
    private static TimeUnit $default$retryDelayUnit() {
        return DEFAULT_RETRY_DELAY_UNIT;
    }

    @Generated
    private static String $default$commonType() {
        return DEFAULT_TYPE;
    }

    @Generated
    private static Level $default$logLevelForSubsequentAttempts() {
        return DEFAULT_RETRY_LOG_LEVEL;
    }

    @ConstructorProperties(value={"environment", "maxAttempts", "retryDelayTime", "retryDelayUnit", "commonType", "logLevelForSubsequentAttempts"})
    @Generated
    SimpleRetryer(KiwiEnvironment environment, int maxAttempts, long retryDelayTime, TimeUnit retryDelayUnit, String commonType, Level logLevelForSubsequentAttempts) {
        this.environment = environment;
        this.maxAttempts = maxAttempts;
        this.retryDelayTime = retryDelayTime;
        this.retryDelayUnit = retryDelayUnit;
        this.commonType = commonType;
        this.logLevelForSubsequentAttempts = logLevelForSubsequentAttempts;
    }

    @Generated
    public static SimpleRetryerBuilder builder() {
        return new SimpleRetryerBuilder();
    }

    @Generated
    public static class SimpleRetryerBuilder {
        @Generated
        private boolean environment$set;
        @Generated
        private KiwiEnvironment environment$value;
        @Generated
        private boolean maxAttempts$set;
        @Generated
        private int maxAttempts$value;
        @Generated
        private boolean retryDelayTime$set;
        @Generated
        private long retryDelayTime$value;
        @Generated
        private boolean retryDelayUnit$set;
        @Generated
        private TimeUnit retryDelayUnit$value;
        @Generated
        private boolean commonType$set;
        @Generated
        private String commonType$value;
        @Generated
        private boolean logLevelForSubsequentAttempts$set;
        @Generated
        private Level logLevelForSubsequentAttempts$value;

        @Generated
        SimpleRetryerBuilder() {
        }

        @Generated
        public SimpleRetryerBuilder environment(KiwiEnvironment environment) {
            this.environment$value = environment;
            this.environment$set = true;
            return this;
        }

        @Generated
        public SimpleRetryerBuilder maxAttempts(int maxAttempts) {
            this.maxAttempts$value = maxAttempts;
            this.maxAttempts$set = true;
            return this;
        }

        @Generated
        public SimpleRetryerBuilder retryDelayTime(long retryDelayTime) {
            this.retryDelayTime$value = retryDelayTime;
            this.retryDelayTime$set = true;
            return this;
        }

        @Generated
        public SimpleRetryerBuilder retryDelayUnit(TimeUnit retryDelayUnit) {
            this.retryDelayUnit$value = retryDelayUnit;
            this.retryDelayUnit$set = true;
            return this;
        }

        @Generated
        public SimpleRetryerBuilder commonType(String commonType) {
            this.commonType$value = commonType;
            this.commonType$set = true;
            return this;
        }

        @Generated
        public SimpleRetryerBuilder logLevelForSubsequentAttempts(Level logLevelForSubsequentAttempts) {
            this.logLevelForSubsequentAttempts$value = logLevelForSubsequentAttempts;
            this.logLevelForSubsequentAttempts$set = true;
            return this;
        }

        @Generated
        public SimpleRetryer build() {
            KiwiEnvironment environment$value = this.environment$value;
            if (!this.environment$set) {
                environment$value = SimpleRetryer.$default$environment();
            }
            int maxAttempts$value = this.maxAttempts$value;
            if (!this.maxAttempts$set) {
                maxAttempts$value = SimpleRetryer.$default$maxAttempts();
            }
            long retryDelayTime$value = this.retryDelayTime$value;
            if (!this.retryDelayTime$set) {
                retryDelayTime$value = SimpleRetryer.$default$retryDelayTime();
            }
            TimeUnit retryDelayUnit$value = this.retryDelayUnit$value;
            if (!this.retryDelayUnit$set) {
                retryDelayUnit$value = SimpleRetryer.$default$retryDelayUnit();
            }
            String commonType$value = this.commonType$value;
            if (!this.commonType$set) {
                commonType$value = SimpleRetryer.$default$commonType();
            }
            Level logLevelForSubsequentAttempts$value = this.logLevelForSubsequentAttempts$value;
            if (!this.logLevelForSubsequentAttempts$set) {
                logLevelForSubsequentAttempts$value = SimpleRetryer.$default$logLevelForSubsequentAttempts();
            }
            return new SimpleRetryer(environment$value, maxAttempts$value, retryDelayTime$value, retryDelayUnit$value, commonType$value, logLevelForSubsequentAttempts$value);
        }

        @Generated
        public String toString() {
            return "SimpleRetryer.SimpleRetryerBuilder(environment$value=" + String.valueOf(this.environment$value) + ", maxAttempts$value=" + this.maxAttempts$value + ", retryDelayTime$value=" + this.retryDelayTime$value + ", retryDelayUnit$value=" + String.valueOf((Object)this.retryDelayUnit$value) + ", commonType$value=" + this.commonType$value + ", logLevelForSubsequentAttempts$value=" + String.valueOf(this.logLevelForSubsequentAttempts$value) + ")";
        }
    }
}

