/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.validation.group;

import jakarta.validation.ConstraintViolation;
import jakarta.validation.Validator;
import jakarta.validation.groups.Default;
import java.util.Arrays;
import java.util.Set;
import lombok.Generated;
import org.kiwiproject.base.KiwiPreconditions;
import org.kiwiproject.validation.KiwiValidations;
import org.kiwiproject.validation.group.ExistingObject;
import org.kiwiproject.validation.group.NewObject;

public final class KiwiValidationGroups {
    private static final Class<?>[] NEW_OBJECT_GROUPS = new Class[]{NewObject.class, Default.class};
    private static final Class<?>[] EXISTING_OBJECT_GROUPS = new Class[]{ExistingObject.class, Default.class};
    private static final Validator DEFAULT_VALIDATOR = KiwiValidations.newValidator();

    public static Class<?>[] newObjectGroups() {
        return Arrays.copyOf(NEW_OBJECT_GROUPS, NEW_OBJECT_GROUPS.length);
    }

    public static Class<?>[] existingObjectGroups() {
        return Arrays.copyOf(EXISTING_OBJECT_GROUPS, EXISTING_OBJECT_GROUPS.length);
    }

    public static <T> Set<ConstraintViolation<T>> validateNewObject(T object) {
        return KiwiValidationGroups.validateNewObject(DEFAULT_VALIDATOR, object);
    }

    public static <T> Set<ConstraintViolation<T>> validateNewObject(Validator validator, T object) {
        KiwiPreconditions.checkArgumentNotNull(validator);
        return validator.validate(object, (Class[])NEW_OBJECT_GROUPS);
    }

    public static <T> Set<ConstraintViolation<T>> validateExistingObject(T object) {
        return KiwiValidationGroups.validateExistingObject(DEFAULT_VALIDATOR, object);
    }

    public static <T> Set<ConstraintViolation<T>> validateExistingObject(Validator validator, T object) {
        KiwiPreconditions.checkArgumentNotNull(validator);
        return validator.validate(object, (Class[])EXISTING_OBJECT_GROUPS);
    }

    @Generated
    private KiwiValidationGroups() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

