/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.xml;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.JAXBIntrospector;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.PropertyException;
import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.annotation.XmlType;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Stream;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.kiwiproject.base.KiwiPreconditions;
import org.kiwiproject.base.KiwiStrings;
import org.kiwiproject.collect.KiwiMaps;
import org.kiwiproject.io.KiwiIO;
import org.kiwiproject.logging.LazyLogParameterSupplier;
import org.kiwiproject.xml.UncheckedJAXBException;
import org.kiwiproject.xml.XmlRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KiwiXml {
    @Generated
    private static final Logger LOG = LoggerFactory.getLogger(KiwiXml.class);
    public static final String DISABLE_NAMESPACE_VALIDATION = "*";
    private static final String NAME_KEY = "name";
    private static final String NAMESPACE_KEY = "namespace";
    private static final String PREFIX_MATCH = "([\\w\\d]+:)?";
    private static final List<String> DEFAULT_IGNORED_NAMESPACES = List.of("##default");
    private static final ConcurrentMap<Class<?>, JAXBContext> jaxbContextMap = new ConcurrentHashMap();

    public static Set<Class<?>> getCachedJAXBContextClasses() {
        return Set.copyOf(jaxbContextMap.keySet());
    }

    public static void clearCachedJAXBContextClasses() {
        jaxbContextMap.clear();
    }

    public static String toXml(Object object) {
        KiwiPreconditions.checkArgumentNotNull(object);
        return KiwiXml.toXml(object, object.getClass());
    }

    public static String toXml(Object object, Class<?> clazz) {
        return KiwiXml.toXml(object, clazz, Map.of());
    }

    public static String toXml(Object object, Class<?> clazz, Map<String, Object> marshallerProperties) {
        KiwiPreconditions.checkArgumentNotNull(object, "object cannot be null");
        KiwiPreconditions.checkArgumentNotNull(clazz, "clazz cannot be null");
        try {
            StringWriter writer = new StringWriter();
            JAXBContext context = KiwiXml.getJaxbContext(clazz);
            JAXBIntrospector introspector = context.createJAXBIntrospector();
            Marshaller marshaller = KiwiXml.createMarshaller(context, marshallerProperties);
            if (Objects.isNull(introspector.getElementName(object))) {
                JAXBElement<?> jaxbElement = KiwiXml.createJaxbWrappedObject(object);
                marshaller.marshal(jaxbElement, (Writer)writer);
            } else {
                marshaller.marshal(object, (Writer)writer);
            }
            return writer.toString();
        }
        catch (XmlRuntimeException xre) {
            LOG.error("Error converting object to XML", (Throwable)xre);
            throw xre;
        }
        catch (Exception e) {
            LOG.error("Unknown error converting object to XML", (Throwable)e);
            throw new XmlRuntimeException("Unable to convert to XML", e);
        }
    }

    private static Marshaller createMarshaller(JAXBContext context, Map<String, Object> marshallerProperties) throws JAXBException {
        Marshaller marshaller = context.createMarshaller();
        HashMap<String, Object> properties = Objects.isNull(marshallerProperties) ? new HashMap<String, Object>() : new HashMap<String, Object>(marshallerProperties);
        properties.putIfAbsent("jaxb.formatted.output", true);
        properties.forEach((k, v) -> KiwiXml.setMarshallerProperty(marshaller, k, v));
        return marshaller;
    }

    private static void setMarshallerProperty(Marshaller marshaller, String key, Object value) {
        try {
            marshaller.setProperty(key, value);
        }
        catch (PropertyException e) {
            LOG.error("Encountered exception setting property: {}, with value: {}", (Object)key, value);
            throw new XmlRuntimeException("Unable to configure marshaller properties", e);
        }
    }

    private static JAXBElement<?> createJaxbWrappedObject(Object objectToTranslate) {
        Map<String, String> nameAndNamespace = KiwiXml.getNameAndNamespace(objectToTranslate.getClass());
        QName qName = new QName(nameAndNamespace.get(NAMESPACE_KEY), nameAndNamespace.get(NAME_KEY));
        return new JAXBElement(qName, Object.class, objectToTranslate);
    }

    public static <T> T toObject(String xml, Class<T> clazz) {
        return KiwiXml.toObjectAssertingValid(xml, clazz, NamespaceValidation.YES);
    }

    public static <T> T toObjectIgnoringNamespace(String xml, Class<T> clazz) {
        return KiwiXml.toObjectAssertingValid(xml, clazz, NamespaceValidation.NO, List.of(DISABLE_NAMESPACE_VALIDATION));
    }

    public static <T> T toObjectAssertingValid(String xml, Class<T> clazz, NamespaceValidation namespaceValidation) {
        return KiwiXml.toObjectAssertingValid(xml, clazz, namespaceValidation, DEFAULT_IGNORED_NAMESPACES);
    }

    public static <T> T toObjectAssertingValid(String xml, Class<T> clazz, NamespaceValidation namespaceValidation, List<String> ignoredNamespaces) {
        KiwiPreconditions.checkArgumentNotBlank(xml, "xml cannot be blank");
        KiwiPreconditions.checkArgumentNotNull(clazz, "clazz cannot be null");
        try {
            if (namespaceValidation == NamespaceValidation.YES) {
                KiwiPreconditions.checkArgument(KiwiXml.validateXmlMatchesType(xml, clazz), IllegalArgumentException.class, "XML namespace does not match expected type");
            }
            return KiwiXml.tryWithFactory(xml, clazz, ignoredNamespaces);
        }
        catch (JAXBException e) {
            throw KiwiXml.newXmlRuntimeException(e.getLinkedException(), xml);
        }
        catch (XMLStreamException e) {
            throw KiwiXml.newXmlRuntimeException(e.getNestedException(), xml);
        }
        catch (Exception e) {
            throw KiwiXml.newXmlRuntimeException(e, xml);
        }
    }

    public static <T> boolean validateXmlMatchesType(String xml, Class<T> clazz) {
        return KiwiXml.validateXmlMatchesType(xml, clazz, DEFAULT_IGNORED_NAMESPACES);
    }

    public static <T> boolean validateXmlMatchesType(String xml, Class<T> clazz, List<String> ignoredNamespaces) {
        String classNamespace;
        String xmlns;
        KiwiPreconditions.checkArgumentNotBlank(xml);
        KiwiPreconditions.checkArgumentNotNull(clazz);
        KiwiPreconditions.checkArgumentNotNull(ignoredNamespaces);
        try {
            String xmlNamespaceURI = KiwiStrings.blankToNull(KiwiXml.getRootQualifiedName(xml).getNamespaceURI());
            xmlns = KiwiXml.filterIgnoredNamespaces(ignoredNamespaces, xmlNamespaceURI);
            String clazzNamespace = KiwiStrings.blankToNull(KiwiXml.getNameAndNamespace(clazz).get(NAMESPACE_KEY));
            classNamespace = KiwiXml.filterIgnoredNamespaces(ignoredNamespaces, clazzNamespace);
            if (StringUtils.equals((CharSequence)xmlns, (CharSequence)classNamespace)) {
                LOG.trace("Return true for xmlns: {} and classNamespace: {}", (Object)xmlns, (Object)classNamespace);
                return true;
            }
            if (StringUtils.isBlank((CharSequence)xmlns) || StringUtils.isBlank((CharSequence)classNamespace)) {
                LOG.info("Skipping validation of namespace for class: {}, with namespace: '{}', and XML with namespace: '{}'. One or both are blank or ignored.", new Object[]{clazz.getName(), classNamespace, xmlns});
                return true;
            }
        }
        catch (Exception e) {
            throw new XmlRuntimeException(e);
        }
        LOG.warn("XML root element with namespace: '{}' does not match expected namespace: '{}', of class: '{}'", new Object[]{xmlns, classNamespace, clazz.getName()});
        return false;
    }

    /*
     * Loose catch block
     */
    private static QName getRootQualifiedName(String xml) throws XMLStreamException {
        StringReader stringReader;
        XMLStreamReader xmlStreamReader;
        block9: {
            xmlStreamReader = null;
            stringReader = new StringReader(xml);
            XMLInputFactory xmlInputFactory = KiwiXml.newSecureXMLInputFactory();
            xmlStreamReader = xmlInputFactory.createXMLStreamReader(stringReader);
            if (!xmlStreamReader.hasNext()) break block9;
            int event = xmlStreamReader.next();
            while (event != 1 && xmlStreamReader.hasNext()) {
                event = xmlStreamReader.next();
            }
            if (!xmlStreamReader.isStartElement()) break block9;
            QName qName = xmlStreamReader.getName();
            stringReader.close();
            KiwiIO.closeQuietly(xmlStreamReader);
            return qName;
        }
        try {
            throw new XmlRuntimeException("Unable to determine root element namespace");
            {
                catch (Throwable throwable) {
                    try {
                        stringReader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
        }
        catch (Throwable throwable) {
            KiwiIO.closeQuietly(xmlStreamReader);
            throw throwable;
        }
    }

    private static String filterIgnoredNamespaces(List<String> ignoredNamespaces, String namespace) {
        boolean shouldIgnore;
        boolean bl = shouldIgnore = Objects.isNull(namespace) || ignoredNamespaces.contains(namespace);
        if (shouldIgnore) {
            LOG.debug("Ignoring namespace: '{}', treating as null", (Object)namespace);
        }
        return shouldIgnore ? null : namespace;
    }

    /*
     * Loose catch block
     */
    private static <T> T tryWithFactory(String xml, Class<T> clazz, List<String> ignoredNamespaces) throws JAXBException, XMLStreamException {
        XMLStreamReader xmlStreamReader = null;
        StringReader stringReader = new StringReader(xml);
        JAXBContext jaxbContext = KiwiXml.getJaxbContext(clazz);
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        XMLInputFactory xmlInputFactory = KiwiXml.newSecureXMLInputFactory();
        xmlInputFactory.setProperty("javax.xml.stream.isNamespaceAware", KiwiXml.isNamespaceAware(ignoredNamespaces));
        xmlStreamReader = xmlInputFactory.createXMLStreamReader(stringReader);
        JAXBElement rootElement = unmarshaller.unmarshal(xmlStreamReader, clazz);
        Object object = rootElement.getValue();
        stringReader.close();
        KiwiIO.closeQuietly(xmlStreamReader);
        return (T)object;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        stringReader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Throwable throwable3) {
                    KiwiIO.closeQuietly(xmlStreamReader);
                    throw throwable3;
                }
            }
        }
    }

    private static synchronized JAXBContext getJaxbContext(Class<?> clazz) {
        return jaxbContextMap.computeIfAbsent(clazz, KiwiXml::newJaxbContext);
    }

    private static JAXBContext newJaxbContext(Class<?> clazz) {
        try {
            return JAXBContext.newInstance((Class[])new Class[]{clazz});
        }
        catch (JAXBException e) {
            throw new UncheckedJAXBException("Error creating JAXBContext for " + String.valueOf(clazz), e);
        }
    }

    private static XMLInputFactory newSecureXMLInputFactory() {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        factory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
        return factory;
    }

    private static boolean isNamespaceAware(List<String> ignoredNamespaces) {
        return !ignoredNamespaces.contains(DISABLE_NAMESPACE_VALIDATION);
    }

    private static XmlRuntimeException newXmlRuntimeException(Throwable cause, String xml) {
        LOG.trace("Encountered error trying to unmarshal XML: {}", LazyLogParameterSupplier.lazy(() -> StringUtils.abbreviate((String)xml, (int)256)));
        return new XmlRuntimeException("Unable to unmarshal XML", cause);
    }

    public static Map<String, String> getNameAndNamespace(Class<?> objectClass) {
        KiwiPreconditions.checkArgumentNotNull(objectClass);
        return Optional.ofNullable(objectClass.getAnnotation(XmlType.class)).map(KiwiXml::getNameAndNamespace).orElseGet(() -> KiwiMaps.newHashMap(NAMESPACE_KEY, null, NAME_KEY, objectClass.getSimpleName()));
    }

    private static Map<String, String> getNameAndNamespace(XmlType xmlTypeAnnotation) {
        return KiwiMaps.newHashMap(NAMESPACE_KEY, xmlTypeAnnotation.namespace(), NAME_KEY, xmlTypeAnnotation.name());
    }

    public static String stripTags(String xml, String ... tagsToRemove) {
        String[] namespacedTagsToRemove = (String[])Stream.of(tagsToRemove).map(tag -> PREFIX_MATCH + tag).toArray(String[]::new);
        return KiwiXml.stripTagsConsideringNamespace(xml, namespacedTagsToRemove);
    }

    public static String stripTagsConsideringNamespace(String xml, String ... tagsToRemove) {
        return Arrays.stream(tagsToRemove).reduce(xml, (accumulatedXml, tagToRemove) -> {
            String tagRegex = "<" + tagToRemove + ">[\\s\\S\\w\\W]*</" + tagToRemove + ">";
            return accumulatedXml.replaceAll(tagRegex, "");
        });
    }

    @Generated
    private KiwiXml() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static enum NamespaceValidation {
        YES,
        NO;

    }
}

