/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.jersey.client.dropwizard;

import com.google.common.base.Preconditions;
import io.dropwizard.client.JerseyClientBuilder;
import io.dropwizard.client.JerseyClientConfiguration;
import io.dropwizard.setup.Environment;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.ws.rs.client.Client;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.kiwiproject.base.KiwiPreconditions;
import org.kiwiproject.config.TlsContextConfiguration;
import org.kiwiproject.config.provider.TlsConfigProvider;
import org.kiwiproject.jersey.client.RegistryAwareClient;
import org.kiwiproject.jersey.client.RegistryAwareClientConstants;
import org.kiwiproject.registry.client.RegistryClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DropwizardManagedClientBuilder {
    @Generated
    private static final Logger LOG = LoggerFactory.getLogger(DropwizardManagedClientBuilder.class);
    private String clientName;
    private Environment environment;
    private RegistryClient registryClient;
    private JerseyClientConfiguration jerseyClientConfiguration;
    private TlsConfigProvider tlsConfigProvider;
    private boolean tlsOptedOut;

    public DropwizardManagedClientBuilder clientName(String clientName) {
        this.clientName = clientName;
        return this;
    }

    public DropwizardManagedClientBuilder environment(Environment environment) {
        this.environment = environment;
        return this;
    }

    public DropwizardManagedClientBuilder registryClient(RegistryClient registryClient) {
        this.registryClient = registryClient;
        return this;
    }

    public DropwizardManagedClientBuilder jerseyClientConfiguration(JerseyClientConfiguration jerseyClientConfiguration) {
        this.jerseyClientConfiguration = jerseyClientConfiguration;
        return this;
    }

    public DropwizardManagedClientBuilder tlsContextConfiguration(TlsContextConfiguration tlsConfig) {
        KiwiPreconditions.checkArgumentNotNull((Object)tlsConfig, (String)"tlsConfig must not be null");
        TlsConfigProvider tlsProvider = TlsConfigProvider.builder().tlsContextConfigurationSupplier(() -> tlsConfig).build();
        return this.tlsConfigProvider(tlsProvider);
    }

    public DropwizardManagedClientBuilder tlsConfigProvider(TlsConfigProvider tlsConfigProvider) {
        this.tlsConfigProvider = tlsConfigProvider;
        return this;
    }

    public DropwizardManagedClientBuilder withoutTls() {
        this.tlsOptedOut = true;
        return this;
    }

    public Client buildManagedJerseyClient() {
        Preconditions.checkState((boolean)StringUtils.isNotBlank((CharSequence)this.clientName), (Object)"A name for the managed client must be specified");
        Preconditions.checkState((boolean)Objects.nonNull(this.environment), (Object)"Dropwizard environment must be provided to create managed client");
        if (Objects.isNull(this.jerseyClientConfiguration)) {
            TlsConfigProvider provider = this.tlsOptedOut ? null : this.tlsConfigProvider;
            this.jerseyClientConfiguration(DropwizardManagedClientBuilder.newDefaultJerseyClientConfiguration(provider));
        }
        return new JerseyClientBuilder(this.environment).using(this.jerseyClientConfiguration).build(this.clientName);
    }

    public RegistryAwareClient buildManagedRegistryAwareClient() {
        Preconditions.checkState((boolean)Objects.nonNull(this.registryClient), (Object)"Registry Client is required for a Registry Aware Client to be created");
        Client jerseyClient = this.buildManagedJerseyClient();
        return new RegistryAwareClient(jerseyClient, this.registryClient);
    }

    public static JerseyClientConfiguration newDefaultJerseyClientConfiguration() {
        return DropwizardManagedClientBuilder.newDefaultJerseyClientConfiguration(null);
    }

    public static JerseyClientConfiguration newDefaultJerseyClientConfiguration(@Nullable TlsConfigProvider tlsConfigProvider) {
        JerseyClientConfiguration config = new JerseyClientConfiguration();
        config.setConnectionRequestTimeout(RegistryAwareClientConstants.DEFAULT_CONNECTION_POOL_TIMEOUT);
        config.setConnectionTimeout(RegistryAwareClientConstants.DEFAULT_CONNECT_TIMEOUT);
        config.setTimeout(RegistryAwareClientConstants.DEFAULT_READ_TIMEOUT);
        if (Objects.isNull(tlsConfigProvider)) {
            return config;
        }
        if (tlsConfigProvider.canProvide()) {
            config.setTlsConfiguration(tlsConfigProvider.getTlsContextConfiguration().toDropwizardTlsConfiguration());
        } else {
            LOG.warn("TlsConfigProvider.canProvide() returned false; custom TlsConfiguration cannot be set for default JerseyClientConfiguration");
        }
        return config;
    }
}

