/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.jersey.client;

import com.google.common.base.Preconditions;
import java.util.Collection;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.ws.rs.client.Client;
import lombok.Generated;
import org.glassfish.jersey.client.JerseyClientBuilder;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.kiwiproject.config.TlsContextConfiguration;
import org.kiwiproject.config.provider.TlsConfigProvider;
import org.kiwiproject.jersey.client.ClientBuilder;
import org.kiwiproject.jersey.client.RegistryAwareClient;
import org.kiwiproject.registry.client.RegistryClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegistryAwareClientBuilder
implements ClientBuilder {
    @Generated
    private static final Logger LOG = LoggerFactory.getLogger(RegistryAwareClientBuilder.class);
    private final JerseyClientBuilder jerseyClientBuilder = new JerseyClientBuilder();
    private boolean sslContextWasSetOnThis;
    private RegistryClient registryClient;

    @Override
    public ClientBuilder multipart() {
        this.jerseyClientBuilder.register(MultiPartFeature.class);
        return this;
    }

    @Override
    public ClientBuilder connectTimeout(int millis) {
        this.jerseyClientBuilder.property("jersey.config.client.connectTimeout", (Object)millis);
        return this;
    }

    @Override
    public ClientBuilder connectTimeout(long millis) {
        return this.connectTimeout(Math.toIntExact(millis));
    }

    @Override
    public ClientBuilder readTimeout(int millis) {
        this.jerseyClientBuilder.property("jersey.config.client.readTimeout", (Object)millis);
        return this;
    }

    @Override
    public ClientBuilder readTimeout(long millis) {
        return this.readTimeout(Math.toIntExact(millis));
    }

    @Override
    public ClientBuilder hostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.jerseyClientBuilder.hostnameVerifier(hostnameVerifier);
        return this;
    }

    @Override
    public ClientBuilder sslContext(SSLContext sslContext) {
        this.jerseyClientBuilder.sslContext(sslContext);
        this.sslContextWasSetOnThis = true;
        return this;
    }

    @Override
    public ClientBuilder registryClient(RegistryClient registryClient) {
        this.registryClient = registryClient;
        return this;
    }

    @Override
    public ClientBuilder tlsConfigProvider(TlsConfigProvider tlsConfigProvider) {
        Preconditions.checkState((boolean)tlsConfigProvider.canProvide(), (Object)"TlsConfigProvider is unable to provide TLS properties");
        TlsContextConfiguration tlsContextConfig = tlsConfigProvider.getTlsContextConfiguration();
        try {
            return this.sslContext(tlsContextConfig.toSSLContext());
        }
        catch (Exception e) {
            LOG.warn("Unable to convert TlsContextConfiguration to SSLContext");
            LOG.debug("TlsContextConfiguration conversion exception: ", (Throwable)e);
            return this;
        }
    }

    @Override
    public RegistryAwareClient build() {
        Collection configPropertyNames = this.jerseyClientBuilder.getConfiguration().getPropertyNames();
        this.setConnectTimeoutIfNotConfigured(configPropertyNames);
        this.setReadTimeoutIfNotConfigured(configPropertyNames);
        if (!this.sslContextWasSetOnThis) {
            LOG.info("No SSLContext provided; this client will use system default TLS via SSLConnectionSocketFactory.getSocketFactory()");
        }
        return new RegistryAwareClient((Client)this.jerseyClientBuilder.build(), this.registryClient);
    }

    private void setConnectTimeoutIfNotConfigured(Collection<String> configPropertyNames) {
        if (!configPropertyNames.contains("jersey.config.client.connectTimeout")) {
            LOG.trace("Connect timeout not configured; setting global default to {}ms", (Object)5000);
            this.connectTimeout(5000);
        }
    }

    private void setReadTimeoutIfNotConfigured(Collection<String> configPropertyNames) {
        if (!configPropertyNames.contains("jersey.config.client.readTimeout")) {
            LOG.trace("Read timeout not configured; setting global default to {}ms", (Object)5000);
            this.readTimeout(5000);
        }
    }
}

