/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.jersey.client;

import com.google.common.annotations.VisibleForTesting;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.UriBuilder;
import lombok.Generated;
import org.kiwiproject.base.KiwiStrings;
import org.kiwiproject.jersey.client.ServiceIdentifier;
import org.kiwiproject.registry.client.RegistryClient;
import org.kiwiproject.registry.model.Port;
import org.kiwiproject.registry.model.ServiceInstance;
import org.kiwiproject.registry.util.ServiceInstancePaths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegistryAwareClient
implements Client {
    @Generated
    private static final Logger LOG = LoggerFactory.getLogger(RegistryAwareClient.class);
    private final Client client;
    @VisibleForTesting
    private final RegistryClient registryClient;

    public RegistryAwareClient(Client client, RegistryClient registryClient) {
        this.client = client;
        this.registryClient = registryClient;
    }

    public Client client() {
        return this.client;
    }

    public WebTarget targetForService(String serviceName) {
        return this.targetForService(ServiceIdentifier.builder().serviceName(serviceName).build());
    }

    public WebTarget targetForService(ServiceIdentifier identifier) {
        RegistryClient.InstanceQuery instanceQuery = RegistryClient.InstanceQuery.builder().serviceName(identifier.getServiceName()).preferredVersion(identifier.getPreferredVersion()).minimumVersion(identifier.getMinimumVersion()).build();
        LOG.trace("Find instances with name {}, preferredVersion {}, minimumVersion {}", new Object[]{instanceQuery.getServiceName(), instanceQuery.getPreferredVersion(), instanceQuery.getMinimumVersion()});
        String uri = this.registryClient.findServiceInstanceBy(instanceQuery).map(instance -> RegistryAwareClient.buildInstanceUri(identifier, instance)).orElseThrow(() -> RegistryAwareClient.newMissingServiceRuntimeException(identifier));
        return this.client.target(uri);
    }

    private static String buildInstanceUri(ServiceIdentifier identifier, ServiceInstance instance) {
        String path = identifier.getConnector() == Port.PortType.APPLICATION ? instance.getPaths().getHomePagePath() : "/";
        return ServiceInstancePaths.urlForPath((String)instance.getHostName(), (List)instance.getPorts(), (Port.PortType)identifier.getConnector(), (String)path);
    }

    private static MissingServiceRuntimeException newMissingServiceRuntimeException(ServiceIdentifier identifier) {
        String message = KiwiStrings.f((String)"No service instances found with name {}, preferred version {}, min version {}", (Object[])new Object[]{identifier.getServiceName(), Optional.ofNullable(identifier.getPreferredVersion()).orElse("[latest]"), Optional.ofNullable(identifier.getMinimumVersion()).orElse("[none]")});
        return new MissingServiceRuntimeException(message);
    }

    @Generated
    RegistryClient getRegistryClient() {
        return this.registryClient;
    }

    @Generated
    public void close() {
        this.client.close();
    }

    @Generated
    public WebTarget target(String arg0) {
        return this.client.target(arg0);
    }

    @Generated
    public WebTarget target(URI arg0) {
        return this.client.target(arg0);
    }

    @Generated
    public WebTarget target(UriBuilder arg0) {
        return this.client.target(arg0);
    }

    @Generated
    public WebTarget target(Link arg0) {
        return this.client.target(arg0);
    }

    @Generated
    public Invocation.Builder invocation(Link arg0) {
        return this.client.invocation(arg0);
    }

    @Generated
    public SSLContext getSslContext() {
        return this.client.getSslContext();
    }

    @Generated
    public HostnameVerifier getHostnameVerifier() {
        return this.client.getHostnameVerifier();
    }

    @Generated
    public Configuration getConfiguration() {
        return this.client.getConfiguration();
    }

    @Generated
    public Client property(String arg0, Object arg1) {
        return (Client)this.client.property(arg0, arg1);
    }

    @Generated
    public Client register(Class<?> arg0) {
        return (Client)this.client.register(arg0);
    }

    @Generated
    public Client register(Class<?> arg0, int arg1) {
        return (Client)this.client.register(arg0, arg1);
    }

    @Generated
    public Client register(Class<?> arg0, Class<?> ... arg1) {
        return (Client)this.client.register(arg0, (Class[])arg1);
    }

    @Generated
    public Client register(Class<?> arg0, Map<Class<?>, Integer> arg1) {
        return (Client)this.client.register(arg0, arg1);
    }

    @Generated
    public Client register(Object arg0) {
        return (Client)this.client.register(arg0);
    }

    @Generated
    public Client register(Object arg0, int arg1) {
        return (Client)this.client.register(arg0, arg1);
    }

    @Generated
    public Client register(Object arg0, Class<?> ... arg1) {
        return (Client)this.client.register(arg0, (Class[])arg1);
    }

    @Generated
    public Client register(Object arg0, Map<Class<?>, Integer> arg1) {
        return (Client)this.client.register(arg0, arg1);
    }

    static class MissingServiceRuntimeException
    extends RuntimeException {
        public MissingServiceRuntimeException(String message) {
            super(message);
        }
    }
}

