/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.jersey.client;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.dropwizard.util.Duration;
import java.util.Optional;
import lombok.Generated;
import org.kiwiproject.base.KiwiPreconditions;
import org.kiwiproject.jersey.client.RegistryAwareClientConstants;
import org.kiwiproject.registry.model.Port;

public final class ServiceIdentifier {
    private final String serviceName;
    private final String preferredVersion;
    private final String minimumVersion;
    private final Port.PortType connector;
    private final Duration connectTimeout;
    private final Duration readTimeout;

    @JsonCreator
    private ServiceIdentifier(@JsonProperty(value="serviceName") String serviceName, @JsonProperty(value="preferredVersion") String preferredVersion, @JsonProperty(value="minimumVersion") String minimumVersion, @JsonProperty(value="connector") Port.PortType connector, @JsonProperty(value="connectTimeout") Duration connectTimeout, @JsonProperty(value="readTimeout") Duration readTimeout) {
        KiwiPreconditions.checkArgumentNotBlank((String)serviceName, (String)"Service name is required");
        this.serviceName = serviceName;
        this.preferredVersion = preferredVersion;
        this.minimumVersion = minimumVersion;
        this.connector = Optional.ofNullable(connector).orElse(Port.PortType.APPLICATION);
        this.connectTimeout = Optional.ofNullable(connectTimeout).orElse(RegistryAwareClientConstants.DEFAULT_CONNECT_TIMEOUT);
        this.readTimeout = Optional.ofNullable(readTimeout).orElse(RegistryAwareClientConstants.DEFAULT_READ_TIMEOUT);
    }

    public static ServiceIdentifier copyOf(ServiceIdentifier original) {
        return original.toBuilder().build();
    }

    @Generated
    public static ServiceIdentifierBuilder builder() {
        return new ServiceIdentifierBuilder();
    }

    @Generated
    public ServiceIdentifierBuilder toBuilder() {
        return new ServiceIdentifierBuilder().serviceName(this.serviceName).preferredVersion(this.preferredVersion).minimumVersion(this.minimumVersion).connector(this.connector).connectTimeout(this.connectTimeout).readTimeout(this.readTimeout);
    }

    @Generated
    public String getServiceName() {
        return this.serviceName;
    }

    @Generated
    public String getPreferredVersion() {
        return this.preferredVersion;
    }

    @Generated
    public String getMinimumVersion() {
        return this.minimumVersion;
    }

    @Generated
    public Port.PortType getConnector() {
        return this.connector;
    }

    @Generated
    public Duration getConnectTimeout() {
        return this.connectTimeout;
    }

    @Generated
    public Duration getReadTimeout() {
        return this.readTimeout;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServiceIdentifier)) {
            return false;
        }
        ServiceIdentifier other = (ServiceIdentifier)o;
        String this$serviceName = this.getServiceName();
        String other$serviceName = other.getServiceName();
        if (this$serviceName == null ? other$serviceName != null : !this$serviceName.equals(other$serviceName)) {
            return false;
        }
        String this$preferredVersion = this.getPreferredVersion();
        String other$preferredVersion = other.getPreferredVersion();
        if (this$preferredVersion == null ? other$preferredVersion != null : !this$preferredVersion.equals(other$preferredVersion)) {
            return false;
        }
        String this$minimumVersion = this.getMinimumVersion();
        String other$minimumVersion = other.getMinimumVersion();
        if (this$minimumVersion == null ? other$minimumVersion != null : !this$minimumVersion.equals(other$minimumVersion)) {
            return false;
        }
        Port.PortType this$connector = this.getConnector();
        Port.PortType other$connector = other.getConnector();
        if (this$connector == null ? other$connector != null : !this$connector.equals(other$connector)) {
            return false;
        }
        Duration this$connectTimeout = this.getConnectTimeout();
        Duration other$connectTimeout = other.getConnectTimeout();
        if (this$connectTimeout == null ? other$connectTimeout != null : !this$connectTimeout.equals(other$connectTimeout)) {
            return false;
        }
        Duration this$readTimeout = this.getReadTimeout();
        Duration other$readTimeout = other.getReadTimeout();
        return !(this$readTimeout == null ? other$readTimeout != null : !this$readTimeout.equals(other$readTimeout));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $serviceName = this.getServiceName();
        result = result * 59 + ($serviceName == null ? 43 : $serviceName.hashCode());
        String $preferredVersion = this.getPreferredVersion();
        result = result * 59 + ($preferredVersion == null ? 43 : $preferredVersion.hashCode());
        String $minimumVersion = this.getMinimumVersion();
        result = result * 59 + ($minimumVersion == null ? 43 : $minimumVersion.hashCode());
        Port.PortType $connector = this.getConnector();
        result = result * 59 + ($connector == null ? 43 : $connector.hashCode());
        Duration $connectTimeout = this.getConnectTimeout();
        result = result * 59 + ($connectTimeout == null ? 43 : $connectTimeout.hashCode());
        Duration $readTimeout = this.getReadTimeout();
        result = result * 59 + ($readTimeout == null ? 43 : $readTimeout.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ServiceIdentifier(serviceName=" + this.getServiceName() + ", preferredVersion=" + this.getPreferredVersion() + ", minimumVersion=" + this.getMinimumVersion() + ", connector=" + this.getConnector() + ", connectTimeout=" + this.getConnectTimeout() + ", readTimeout=" + this.getReadTimeout() + ")";
    }

    @Generated
    public ServiceIdentifier withServiceName(String serviceName) {
        return this.serviceName == serviceName ? this : new ServiceIdentifier(serviceName, this.preferredVersion, this.minimumVersion, this.connector, this.connectTimeout, this.readTimeout);
    }

    @Generated
    public static class ServiceIdentifierBuilder {
        @Generated
        private String serviceName;
        @Generated
        private String preferredVersion;
        @Generated
        private String minimumVersion;
        @Generated
        private Port.PortType connector;
        @Generated
        private Duration connectTimeout;
        @Generated
        private Duration readTimeout;

        @Generated
        ServiceIdentifierBuilder() {
        }

        @JsonProperty(value="serviceName")
        @Generated
        public ServiceIdentifierBuilder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        @JsonProperty(value="preferredVersion")
        @Generated
        public ServiceIdentifierBuilder preferredVersion(String preferredVersion) {
            this.preferredVersion = preferredVersion;
            return this;
        }

        @JsonProperty(value="minimumVersion")
        @Generated
        public ServiceIdentifierBuilder minimumVersion(String minimumVersion) {
            this.minimumVersion = minimumVersion;
            return this;
        }

        @JsonProperty(value="connector")
        @Generated
        public ServiceIdentifierBuilder connector(Port.PortType connector) {
            this.connector = connector;
            return this;
        }

        @JsonProperty(value="connectTimeout")
        @Generated
        public ServiceIdentifierBuilder connectTimeout(Duration connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        @JsonProperty(value="readTimeout")
        @Generated
        public ServiceIdentifierBuilder readTimeout(Duration readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        @Generated
        public ServiceIdentifier build() {
            return new ServiceIdentifier(this.serviceName, this.preferredVersion, this.minimumVersion, this.connector, this.connectTimeout, this.readTimeout);
        }

        @Generated
        public String toString() {
            return "ServiceIdentifier.ServiceIdentifierBuilder(serviceName=" + this.serviceName + ", preferredVersion=" + this.preferredVersion + ", minimumVersion=" + this.minimumVersion + ", connector=" + this.connector + ", connectTimeout=" + this.connectTimeout + ", readTimeout=" + this.readTimeout + ")";
        }
    }
}

