/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.jersey.client;

import com.google.common.annotations.VisibleForTesting;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientRequestContext;
import jakarta.ws.rs.client.ClientRequestFilter;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.Link;
import jakarta.ws.rs.core.UriBuilder;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.kiwiproject.base.KiwiPreconditions;
import org.kiwiproject.jersey.client.ServiceIdentifier;
import org.kiwiproject.jersey.client.exception.MissingServiceRuntimeException;
import org.kiwiproject.registry.client.RegistryClient;
import org.kiwiproject.registry.model.Port;
import org.kiwiproject.registry.model.ServiceInstance;
import org.kiwiproject.registry.util.ServiceInstancePaths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegistryAwareClient
implements Client,
AutoCloseable {
    @Generated
    private static final Logger LOG = LoggerFactory.getLogger(RegistryAwareClient.class);
    private final Client client;
    @VisibleForTesting
    private final RegistryClient registryClient;
    private final AtomicBoolean closed;

    public RegistryAwareClient(Client client, RegistryClient registryClient) {
        this(client, registryClient, null);
    }

    public RegistryAwareClient(Client client, RegistryClient registryClient, @Nullable Supplier<Map<String, Object>> headersSupplier) {
        this.client = (Client)KiwiPreconditions.requireNotNull((Object)client, (String)"client must not be null", (Object[])new Object[0]);
        this.registryClient = (RegistryClient)KiwiPreconditions.requireNotNull((Object)registryClient, (String)"registryClient must not be null", (Object[])new Object[0]);
        this.closed = new AtomicBoolean();
        if (Objects.nonNull(headersSupplier)) {
            this.client.register((Object)new AddHeadersOnRequestFilter(headersSupplier));
        }
    }

    public Client client() {
        return this.client;
    }

    @Override
    public void close() {
        this.client.close();
        this.closed.set(true);
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    public WebTarget targetForService(String serviceName) {
        return this.targetForService(serviceName, Port.PortType.APPLICATION);
    }

    public WebTarget targetForService(String serviceName, Port.PortType portType) {
        ServiceIdentifier serviceIdentifier = ServiceIdentifier.builder().serviceName(serviceName).connector(portType).build();
        return this.targetForService(serviceIdentifier);
    }

    public WebTarget targetForService(ServiceIdentifier originalIdentifier, Port.PortType portType) {
        KiwiPreconditions.checkArgumentNotNull((Object)originalIdentifier, (String)"Original ServiceIdentifier must not be null");
        ServiceIdentifier serviceIdentifier = originalIdentifier.withConnector(portType);
        return this.targetForService(serviceIdentifier);
    }

    public WebTarget targetForService(ServiceIdentifier identifier) {
        RegistryClient.InstanceQuery instanceQuery = RegistryClient.InstanceQuery.builder().serviceName(identifier.getServiceName()).preferredVersion(identifier.getPreferredVersion()).minimumVersion(identifier.getMinimumVersion()).build();
        RegistryAwareClient.traceLogInstanceQuery(instanceQuery);
        String uri = this.registryClient.findServiceInstanceBy(instanceQuery).map(instance -> RegistryAwareClient.buildInstanceUri(identifier, instance)).orElseThrow(() -> MissingServiceRuntimeException.from(identifier));
        return this.client.target(uri);
    }

    public WebTarget targetForService(ServiceIdentifier original, Port.PortType portType, Function<ServiceInstance, String> pathResolver) {
        ServiceIdentifier identifier = original.withConnector(portType);
        RegistryClient.InstanceQuery instanceQuery = RegistryClient.InstanceQuery.builder().serviceName(identifier.getServiceName()).preferredVersion(identifier.getPreferredVersion()).minimumVersion(identifier.getMinimumVersion()).build();
        RegistryAwareClient.traceLogInstanceQuery(instanceQuery);
        ServiceInstance serviceInstance = (ServiceInstance)this.registryClient.findServiceInstanceBy(instanceQuery).orElseThrow(() -> MissingServiceRuntimeException.from(identifier));
        String uri = RegistryAwareClient.buildInstanceUri(identifier, serviceInstance);
        return this.client.target(uri).path(pathResolver.apply(serviceInstance));
    }

    private static void traceLogInstanceQuery(RegistryClient.InstanceQuery instanceQuery) {
        LOG.trace("Find instances with name {}, preferredVersion {}, minimumVersion {}", new Object[]{instanceQuery.getServiceName(), instanceQuery.getPreferredVersion(), instanceQuery.getMinimumVersion()});
    }

    private static String buildInstanceUri(ServiceIdentifier identifier, ServiceInstance instance) {
        String path = identifier.getConnector() == Port.PortType.APPLICATION ? instance.getPaths().getHomePagePath() : "/";
        return ServiceInstancePaths.urlForPath((String)instance.getHostName(), (List)instance.getPorts(), (Port.PortType)identifier.getConnector(), (String)path);
    }

    @Generated
    RegistryClient getRegistryClient() {
        return this.registryClient;
    }

    @Generated
    public WebTarget target(String arg0) {
        return this.client.target(arg0);
    }

    @Generated
    public WebTarget target(URI arg0) {
        return this.client.target(arg0);
    }

    @Generated
    public WebTarget target(UriBuilder arg0) {
        return this.client.target(arg0);
    }

    @Generated
    public WebTarget target(Link arg0) {
        return this.client.target(arg0);
    }

    @Generated
    public Invocation.Builder invocation(Link arg0) {
        return this.client.invocation(arg0);
    }

    @Generated
    public SSLContext getSslContext() {
        return this.client.getSslContext();
    }

    @Generated
    public HostnameVerifier getHostnameVerifier() {
        return this.client.getHostnameVerifier();
    }

    @Generated
    public Configuration getConfiguration() {
        return this.client.getConfiguration();
    }

    @Generated
    public Client property(String arg0, Object arg1) {
        return (Client)this.client.property(arg0, arg1);
    }

    @Generated
    public Client register(Class<?> arg0) {
        return (Client)this.client.register(arg0);
    }

    @Generated
    public Client register(Class<?> arg0, int arg1) {
        return (Client)this.client.register(arg0, arg1);
    }

    @Generated
    public Client register(Class<?> arg0, Class<?> ... arg1) {
        return (Client)this.client.register(arg0, (Class[])arg1);
    }

    @Generated
    public Client register(Class<?> arg0, Map<Class<?>, Integer> arg1) {
        return (Client)this.client.register(arg0, arg1);
    }

    @Generated
    public Client register(Object arg0) {
        return (Client)this.client.register(arg0);
    }

    @Generated
    public Client register(Object arg0, int arg1) {
        return (Client)this.client.register(arg0, arg1);
    }

    @Generated
    public Client register(Object arg0, Class<?> ... arg1) {
        return (Client)this.client.register(arg0, (Class[])arg1);
    }

    @Generated
    public Client register(Object arg0, Map<Class<?>, Integer> arg1) {
        return (Client)this.client.register(arg0, arg1);
    }

    @VisibleForTesting
    static class AddHeadersOnRequestFilter
    implements ClientRequestFilter {
        private final Supplier<Map<String, Object>> headersSupplier;

        AddHeadersOnRequestFilter(Supplier<Map<String, Object>> headersSupplier) {
            this.headersSupplier = headersSupplier;
        }

        public void filter(ClientRequestContext requestContext) {
            Map<String, Object> headers = this.headersSupplier.get();
            headers.forEach((key, value) -> requestContext.getHeaders().add(key, value));
        }
    }
}

