/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.jersey.client.filter;

import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientRequestContext;
import jakarta.ws.rs.client.ClientRequestFilter;
import jakarta.ws.rs.core.MultivaluedMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.kiwiproject.base.KiwiPreconditions;
import org.kiwiproject.collect.KiwiMaps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class AddHeadersClientRequestFilter
implements ClientRequestFilter {
    @Generated
    private static final Logger LOG = LoggerFactory.getLogger(AddHeadersClientRequestFilter.class);
    @VisibleForTesting
    final Supplier<Map<String, Object>> headersSupplier;
    @VisibleForTesting
    final Supplier<MultivaluedMap<String, Object>> headersMultivalueSupplier;

    @VisibleForTesting
    AddHeadersClientRequestFilter(Supplier<Map<String, Object>> headersSupplier, Supplier<MultivaluedMap<String, Object>> headersMultivalueSupplier) {
        KiwiPreconditions.checkOnlyOneArgumentIsNull(headersSupplier, headersMultivalueSupplier, (String)"one of headersSupplier and headersMultivalueSupplier must be null, and the other non-null");
        this.headersSupplier = headersSupplier;
        this.headersMultivalueSupplier = headersMultivalueSupplier;
    }

    public static AddHeadersClientRequestFilter fromMapSupplier(Supplier<Map<String, Object>> headersSupplier) {
        return new AddHeadersClientRequestFilter(headersSupplier, null);
    }

    public static AddHeadersClientRequestFilter fromMultivaluedMapSupplier(Supplier<MultivaluedMap<String, Object>> headersMultivalueSupplier) {
        return new AddHeadersClientRequestFilter(null, headersMultivalueSupplier);
    }

    public static void createAndRegister(Client client, @Nullable Supplier<Map<String, Object>> headersSupplier, @Nullable Supplier<MultivaluedMap<String, Object>> headersMultivalueSupplier) {
        if (Objects.nonNull(headersMultivalueSupplier)) {
            client.register((Object)AddHeadersClientRequestFilter.fromMultivaluedMapSupplier(headersMultivalueSupplier));
        } else if (Objects.nonNull(headersSupplier)) {
            client.register((Object)AddHeadersClientRequestFilter.fromMapSupplier(headersSupplier));
        } else {
            LOG.warn("Not registering AddHeadersClientRequestFilter: headersSupplier and headersMultivalueSupplier are both null");
        }
    }

    public void filter(ClientRequestContext requestContext) {
        if (Objects.nonNull(this.headersSupplier)) {
            this.addHeadersFromMap(requestContext);
        } else {
            this.addHeadersFromMultivaluedMap(requestContext);
        }
    }

    private void addHeadersFromMap(ClientRequestContext requestContext) {
        Map<String, Object> map = this.headersSupplier.get();
        if (KiwiMaps.isNullOrEmpty(map)) {
            LOG.warn("No headers to add: Supplier provided null or empty headers Map");
            return;
        }
        if (map instanceof MultivaluedMap) {
            throw new IllegalStateException("Supplier provided MultivaluedMap (for MultivaluedMaps, use fromMultivaluedMapSupplier factory method)");
        }
        MultivaluedMap headers = requestContext.getHeaders();
        map.forEach((arg_0, arg_1) -> ((MultivaluedMap)headers).add(arg_0, arg_1));
    }

    private void addHeadersFromMultivaluedMap(ClientRequestContext requestContext) {
        MultivaluedMap<String, Object> multivaluedMap = this.headersMultivalueSupplier.get();
        if (Objects.isNull(multivaluedMap) || multivaluedMap.isEmpty()) {
            LOG.warn("No headers to add: Supplier provided null or empty headers MultivaluedMap");
            return;
        }
        MultivaluedMap headers = requestContext.getHeaders();
        multivaluedMap.forEach((name, values) -> values.forEach(value -> headers.add(name, value)));
    }
}

