/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.jersey.client;

import com.google.common.base.Preconditions;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.core.MultivaluedMap;
import java.time.Duration;
import java.util.Collection;
import java.util.Map;
import java.util.function.Supplier;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import lombok.Generated;
import org.glassfish.jersey.client.JerseyClient;
import org.glassfish.jersey.client.JerseyClientBuilder;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.kiwiproject.config.TlsContextConfiguration;
import org.kiwiproject.config.provider.TlsConfigProvider;
import org.kiwiproject.jersey.client.ClientBuilder;
import org.kiwiproject.jersey.client.RegistryAwareClient;
import org.kiwiproject.jersey.client.ServiceIdentifier;
import org.kiwiproject.jersey.client.filter.AddHeadersClientRequestFilter;
import org.kiwiproject.jersey.client.net.ssl.NoopHostnameVerifier;
import org.kiwiproject.registry.client.RegistryClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegistryAwareClientBuilder
implements ClientBuilder {
    @Generated
    private static final Logger LOG = LoggerFactory.getLogger(RegistryAwareClientBuilder.class);
    private static final String DEFAULT_TLS_INFO_MESSAGE = "No SSLContext provided; if a connection is made via HTTPS, this client will use system default TLS via SSLConnectionSocketFactory.getSocketFactory()";
    private final JerseyClientBuilder jerseyClientBuilder = new JerseyClientBuilder();
    private boolean sslContextWasSetOnThis;
    private boolean hostnameVerifierWasSetOnThis;
    private RegistryClient registryClient;
    private Supplier<Map<String, Object>> headersSupplier;
    private Supplier<MultivaluedMap<String, Object>> headersMultivalueSupplier;

    @Override
    public ClientBuilder multipart() {
        this.jerseyClientBuilder.register(MultiPartFeature.class);
        return this;
    }

    @Override
    public ClientBuilder connectTimeout(int millis) {
        this.jerseyClientBuilder.property("jersey.config.client.connectTimeout", (Object)millis);
        return this;
    }

    @Override
    public ClientBuilder connectTimeout(long millis) {
        return this.connectTimeout(Math.toIntExact(millis));
    }

    @Override
    public ClientBuilder connectTimeout(Duration timeout) {
        return this.connectTimeout(timeout.toMillis());
    }

    @Override
    public ClientBuilder readTimeout(int millis) {
        this.jerseyClientBuilder.property("jersey.config.client.readTimeout", (Object)millis);
        return this;
    }

    @Override
    public ClientBuilder readTimeout(long millis) {
        return this.readTimeout(Math.toIntExact(millis));
    }

    @Override
    public ClientBuilder readTimeout(Duration timeout) {
        return this.readTimeout(timeout.toMillis());
    }

    @Override
    public ClientBuilder timeoutsFrom(ServiceIdentifier serviceIdentifier) {
        this.connectTimeout(serviceIdentifier.getConnectTimeout().toMilliseconds());
        this.readTimeout(serviceIdentifier.getReadTimeout().toMilliseconds());
        return this;
    }

    @Override
    public ClientBuilder hostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.jerseyClientBuilder.hostnameVerifier(hostnameVerifier);
        this.hostnameVerifierWasSetOnThis = true;
        return this;
    }

    @Override
    public ClientBuilder sslContext(SSLContext sslContext) {
        this.jerseyClientBuilder.sslContext(sslContext);
        this.sslContextWasSetOnThis = true;
        return this;
    }

    @Override
    public ClientBuilder registryClient(RegistryClient registryClient) {
        this.registryClient = registryClient;
        return this;
    }

    @Override
    public ClientBuilder tlsConfigProvider(TlsConfigProvider tlsConfigProvider) {
        Preconditions.checkState((boolean)tlsConfigProvider.canProvide(), (Object)"TlsConfigProvider is unable to provide TLS properties");
        TlsContextConfiguration tlsContextConfig = tlsConfigProvider.getTlsContextConfiguration();
        try {
            return this.sslContext(tlsContextConfig.toSSLContext());
        }
        catch (Exception e) {
            LOG.warn("Unable to convert TlsContextConfiguration to SSLContext: {}: {}", (Object)e.getClass().getName(), (Object)e.getMessage());
            LOG.debug("TlsContextConfiguration conversion exception: ", (Throwable)e);
            return this;
        }
    }

    @Override
    public ClientBuilder property(String name, Object value) {
        this.jerseyClientBuilder.property(name, value);
        return this;
    }

    @Override
    public ClientBuilder registerComponentClass(Class<?> componentClass) {
        this.jerseyClientBuilder.register(componentClass);
        return this;
    }

    @Override
    public ClientBuilder registerComponent(Object component) {
        this.jerseyClientBuilder.register(component);
        return this;
    }

    @Override
    public ClientBuilder headersSupplier(Supplier<Map<String, Object>> headersSupplier) {
        this.headersSupplier = headersSupplier;
        return this;
    }

    @Override
    public ClientBuilder headersMultivaluedSupplier(Supplier<MultivaluedMap<String, Object>> headersMultivalueSupplier) {
        this.headersMultivalueSupplier = headersMultivalueSupplier;
        return this;
    }

    @Override
    public RegistryAwareClient build() {
        Collection configPropertyNames = this.jerseyClientBuilder.getConfiguration().getPropertyNames();
        this.setConnectTimeoutIfNotConfigured(configPropertyNames);
        this.setReadTimeoutIfNotConfigured(configPropertyNames);
        this.setNoopHostNameVerifierIfNotSet();
        if (!this.sslContextWasSetOnThis) {
            LOG.info(DEFAULT_TLS_INFO_MESSAGE);
        }
        JerseyClient client = this.jerseyClientBuilder.build();
        AddHeadersClientRequestFilter.createAndRegister((Client)client, this.headersSupplier, this.headersMultivalueSupplier);
        return new RegistryAwareClient((Client)client, this.registryClient);
    }

    private void setConnectTimeoutIfNotConfigured(Collection<String> configPropertyNames) {
        if (!configPropertyNames.contains("jersey.config.client.connectTimeout")) {
            LOG.trace("Connect timeout not configured; setting global default to {}ms", (Object)5000);
            this.connectTimeout(5000);
        }
    }

    private void setReadTimeoutIfNotConfigured(Collection<String> configPropertyNames) {
        if (!configPropertyNames.contains("jersey.config.client.readTimeout")) {
            LOG.trace("Read timeout not configured; setting global default to {}ms", (Object)5000);
            this.readTimeout(5000);
        }
    }

    private void setNoopHostNameVerifierIfNotSet() {
        if (!this.hostnameVerifierWasSetOnThis) {
            LOG.warn("A hostname verifier has not been configured. Setting the hostname verifier to NoopHostnameVerifier.");
            this.jerseyClientBuilder.hostnameVerifier((HostnameVerifier)new NoopHostnameVerifier());
        }
    }
}

