/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.jersey.client.dropwizard;

import com.google.common.base.Preconditions;
import io.dropwizard.client.JerseyClientBuilder;
import io.dropwizard.client.JerseyClientConfiguration;
import io.dropwizard.core.setup.Environment;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.core.MultivaluedMap;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Supplier;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.jspecify.annotations.Nullable;
import org.kiwiproject.base.KiwiPreconditions;
import org.kiwiproject.base.KiwiStrings;
import org.kiwiproject.config.TlsContextConfiguration;
import org.kiwiproject.config.provider.TlsConfigProvider;
import org.kiwiproject.jersey.client.RegistryAwareClient;
import org.kiwiproject.jersey.client.RegistryAwareClientConstants;
import org.kiwiproject.jersey.client.filter.AddHeadersClientRequestFilter;
import org.kiwiproject.registry.client.RegistryClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DropwizardManagedClientBuilder {
    @Generated
    private static final Logger LOG = LoggerFactory.getLogger(DropwizardManagedClientBuilder.class);
    private String clientName;
    private Environment environment;
    private RegistryClient registryClient;
    private JerseyClientConfiguration jerseyClientConfiguration;
    private TlsConfigProvider tlsConfigProvider;
    private boolean tlsOptedOut;
    private Supplier<Map<String, Object>> headersSupplier;
    private Supplier<MultivaluedMap<String, Object>> headersMultivalueSupplier;
    private final Map<String, Object> properties = new LinkedHashMap<String, Object>();
    private final List<Class<?>> componentClasses;
    private final List<Object> components = new ArrayList<Object>();
    private final List<Consumer<JerseyClientBuilder>> customizers;
    private final AtomicBoolean built;

    public DropwizardManagedClientBuilder() {
        this.componentClasses = new ArrayList();
        this.customizers = new ArrayList<Consumer<JerseyClientBuilder>>();
        this.built = new AtomicBoolean();
    }

    public DropwizardManagedClientBuilder clientName(String clientName) {
        this.clientName = clientName;
        return this;
    }

    public DropwizardManagedClientBuilder environment(Environment environment) {
        this.environment = environment;
        return this;
    }

    public DropwizardManagedClientBuilder registryClient(RegistryClient registryClient) {
        this.registryClient = registryClient;
        return this;
    }

    public DropwizardManagedClientBuilder jerseyClientConfiguration(JerseyClientConfiguration jerseyClientConfiguration) {
        this.jerseyClientConfiguration = jerseyClientConfiguration;
        return this;
    }

    public DropwizardManagedClientBuilder tlsContextConfiguration(TlsContextConfiguration tlsConfig) {
        KiwiPreconditions.checkArgumentNotNull((Object)tlsConfig, (String)"tlsConfig must not be null");
        TlsConfigProvider tlsProvider = TlsConfigProvider.builder().tlsContextConfigurationSupplier(() -> tlsConfig).build();
        return this.tlsConfigProvider(tlsProvider);
    }

    public DropwizardManagedClientBuilder tlsConfigProvider(TlsConfigProvider tlsConfigProvider) {
        this.tlsConfigProvider = tlsConfigProvider;
        return this;
    }

    public DropwizardManagedClientBuilder withoutTls() {
        this.tlsOptedOut = true;
        return this;
    }

    public DropwizardManagedClientBuilder headersSupplier(Supplier<Map<String, Object>> headersSupplier) {
        this.headersSupplier = headersSupplier;
        return this;
    }

    public DropwizardManagedClientBuilder headersMultivalueSupplier(Supplier<MultivaluedMap<String, Object>> headersMultivalueSupplier) {
        this.headersMultivalueSupplier = headersMultivalueSupplier;
        return this;
    }

    public DropwizardManagedClientBuilder property(String name, Object value) {
        this.properties.put(name, value);
        return this;
    }

    public DropwizardManagedClientBuilder registerComponentClass(Class<?> componentClass) {
        KiwiPreconditions.checkArgumentNotNull(componentClass, (String)"componentClass must not be null");
        this.componentClasses.add(componentClass);
        return this;
    }

    public DropwizardManagedClientBuilder registerComponent(Object component) {
        KiwiPreconditions.checkArgumentNotNull((Object)component, (String)"component must not be null");
        this.components.add(component);
        return this;
    }

    public DropwizardManagedClientBuilder customize(Consumer<JerseyClientBuilder> customizer) {
        KiwiPreconditions.checkArgumentNotNull(customizer, (String)"customizer must not be null");
        this.customizers.add(customizer);
        return this;
    }

    public Client buildManagedJerseyClient() {
        Preconditions.checkState((boolean)this.built.compareAndSet(false, true), (Object)"Client was already built using this builder. This is a single-use builder.");
        Preconditions.checkState((boolean)StringUtils.isNotBlank((CharSequence)this.clientName), (Object)"A name for the managed client must be specified");
        Preconditions.checkState((boolean)Objects.nonNull(this.environment), (Object)"Dropwizard environment must be provided to create managed client");
        if (Objects.isNull(this.jerseyClientConfiguration)) {
            TlsConfigProvider provider = this.tlsOptedOut ? null : this.tlsConfigProvider;
            this.jerseyClientConfiguration(DropwizardManagedClientBuilder.newDefaultJerseyClientConfiguration(provider));
        }
        JerseyClientBuilder builder = new JerseyClientBuilder(this.environment).using(this.jerseyClientConfiguration);
        this.properties.forEach((arg_0, arg_1) -> ((JerseyClientBuilder)builder).withProperty(arg_0, arg_1));
        this.componentClasses.forEach(arg_0 -> ((JerseyClientBuilder)builder).withProvider(arg_0));
        this.components.forEach(arg_0 -> ((JerseyClientBuilder)builder).withProvider(arg_0));
        this.applyJerseyClientBuilderCustomizers(builder);
        Client client = builder.build(this.clientName);
        this.registerHeadersClientRequestFilter(client);
        return client;
    }

    private void applyJerseyClientBuilderCustomizers(JerseyClientBuilder builder) {
        if (this.customizers.isEmpty()) {
            return;
        }
        LOG.debug("Applying {} JerseyClientBuilder customizations", (Object)this.customizers.size());
        List<Consumer<JerseyClientBuilder>> snapshot = List.copyOf(this.customizers);
        for (int index = 0; index < snapshot.size(); ++index) {
            Consumer<JerseyClientBuilder> customizer = snapshot.get(index);
            this.applyCustomizer(builder, customizer, index);
        }
    }

    private void applyCustomizer(JerseyClientBuilder builder, Consumer<JerseyClientBuilder> customizer, int index) {
        try {
            customizer.accept(builder);
        }
        catch (Exception e) {
            String message = KiwiStrings.f((String)"Customizer at index {} (0-based) failed while configuring JerseyClientBuilder for client {}", (Object[])new Object[]{index, this.clientName});
            throw new IllegalStateException(message, e);
        }
    }

    private void registerHeadersClientRequestFilter(Client client) {
        boolean bothSet = Objects.nonNull(this.headersSupplier) && Objects.nonNull(this.headersMultivalueSupplier);
        Preconditions.checkState((!bothSet ? 1 : 0) != 0, (Object)"Only one of headersSupplier or headersMultivalueSupplier may be set");
        AddHeadersClientRequestFilter.createAndRegister(client, this.headersSupplier, this.headersMultivalueSupplier);
    }

    public RegistryAwareClient buildManagedRegistryAwareClient() {
        Preconditions.checkState((boolean)Objects.nonNull(this.registryClient), (Object)"Registry Client is required for a Registry Aware Client to be created");
        Client jerseyClient = this.buildManagedJerseyClient();
        return new RegistryAwareClient(jerseyClient, this.registryClient);
    }

    public static JerseyClientConfiguration newDefaultJerseyClientConfiguration() {
        return DropwizardManagedClientBuilder.newDefaultJerseyClientConfiguration(null);
    }

    public static JerseyClientConfiguration newDefaultJerseyClientConfiguration(@Nullable TlsConfigProvider tlsConfigProvider) {
        JerseyClientConfiguration config = new JerseyClientConfiguration();
        config.setConnectionRequestTimeout(RegistryAwareClientConstants.DEFAULT_CONNECTION_POOL_TIMEOUT);
        config.setConnectionTimeout(RegistryAwareClientConstants.DEFAULT_CONNECT_TIMEOUT);
        config.setTimeout(RegistryAwareClientConstants.DEFAULT_READ_TIMEOUT);
        if (Objects.isNull(tlsConfigProvider)) {
            return config;
        }
        if (tlsConfigProvider.canProvide()) {
            config.setTlsConfiguration(tlsConfigProvider.getTlsContextConfiguration().toDropwizardTlsConfiguration());
        } else {
            LOG.warn("TlsConfigProvider.canProvide() returned false; custom TlsConfiguration cannot be set for default JerseyClientConfiguration");
        }
        return config;
    }
}

