/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.registry.eureka.common;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.beans.ConstructorProperties;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.kiwiproject.collect.KiwiMaps;
import org.kiwiproject.registry.model.Port;
import org.kiwiproject.registry.model.ServiceInstance;
import org.kiwiproject.registry.model.ServicePaths;
import org.kiwiproject.registry.util.Ports;
import org.kiwiproject.registry.util.ServiceInstancePaths;

@JsonIgnoreProperties(ignoreUnknown=true)
public final class EurekaInstance {
    private static final String COMMIT_REF_FIELD = "commitRef";
    private static final String DESCRIPTION_FIELD = "description";
    private static final String VERSION_FIELD = "version";
    private static final List<String> METADATA_EXCLUDED_KEYS = List.of("commitRef", "description", "version");
    private final String app;
    private final String status;
    private final Map<String, String> dataCenterInfo;
    private final Map<String, Object> leaseInfo;
    private final String hostName;
    private final String ipAddr;
    private final String vipAddress;
    private final String secureVipAddress;
    private final Map<String, Object> port;
    private final Map<String, Object> securePort;
    private final int adminPort;
    private final String homePageUrl;
    private final String statusPageUrl;
    private final String healthCheckUrl;
    private final Map<String, String> metadata;

    public String getInstanceId() {
        return this.hostName;
    }

    public static EurekaInstance fromServiceInstance(ServiceInstance serviceInstance) {
        String hostName = serviceInstance.getHostName();
        List<Port> ports = serviceInstance.getPorts();
        ServicePaths paths = serviceInstance.getPaths();
        return EurekaInstance.builder().hostName(hostName).ipAddr(serviceInstance.getIp()).vipAddress(serviceInstance.getServiceName()).secureVipAddress(serviceInstance.getServiceName()).status(serviceInstance.getStatus().name()).port(EurekaInstance.portToEurekaPortMap(Ports.findPort(ports, Port.PortType.APPLICATION, Port.Security.NOT_SECURE))).securePort(EurekaInstance.portToEurekaPortMap(Ports.findPort(ports, Port.PortType.APPLICATION, Port.Security.SECURE))).adminPort(EurekaInstance.findFirstAdminPortNumberPreferSecure(ports)).homePageUrl(ServiceInstancePaths.urlForPath(hostName, ports, Port.PortType.APPLICATION, paths.getHomePagePath())).statusPageUrl(ServiceInstancePaths.urlForPath(hostName, ports, Port.PortType.ADMIN, paths.getStatusPath())).healthCheckUrl(ServiceInstancePaths.urlForPath(hostName, ports, Port.PortType.ADMIN, paths.getHealthCheckPath())).metadata(EurekaInstance.mergeMetadata(serviceInstance)).build();
    }

    private static Map<String, String> mergeMetadata(ServiceInstance serviceInstance) {
        Map<String, String> defaultMetadataMap = Map.of(COMMIT_REF_FIELD, serviceInstance.getCommitRef(), DESCRIPTION_FIELD, serviceInstance.getDescription(), VERSION_FIELD, serviceInstance.getVersion());
        if (KiwiMaps.isNullOrEmpty(serviceInstance.getMetadata())) {
            return defaultMetadataMap;
        }
        return Stream.concat(defaultMetadataMap.entrySet().stream(), serviceInstance.getMetadata().entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (value1, value2) -> value2));
    }

    private static Map<String, Object> portToEurekaPortMap(Port port) {
        return Map.of("$", port.getNumber(), "@enabled", port.getNumber() > 0);
    }

    private static int findFirstAdminPortNumberPreferSecure(List<Port> ports) {
        Port firstAdminPort = Ports.findFirstPortPreferSecure(ports, Port.PortType.ADMIN);
        return firstAdminPort.getNumber();
    }

    public ServiceInstance toServiceInstance() {
        List<Port> ports = this.portListFromPortsIgnoringNulls(this.buildAdminPortOrNull(), this.buildApplicationPortOrNull(this.port, Port.Security.NOT_SECURE), this.buildApplicationPortOrNull(this.securePort, Port.Security.SECURE));
        return ServiceInstance.builder().instanceId(this.getInstanceId()).status(ServiceInstance.Status.valueOf(this.status)).serviceName(this.vipAddress).hostName(this.hostName).ip(this.ipAddr).commitRef(this.metadata.get(COMMIT_REF_FIELD)).description(this.metadata.get(DESCRIPTION_FIELD)).version(this.metadata.get(VERSION_FIELD)).metadata(this.filterMetadata()).paths(this.buildPaths()).ports(ports).build();
    }

    private Map<String, String> filterMetadata() {
        return this.metadata.entrySet().stream().filter(entry -> !METADATA_EXCLUDED_KEYS.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private List<Port> portListFromPortsIgnoringNulls(Port ... ports) {
        return Arrays.stream(ports).filter(Objects::nonNull).collect(Collectors.toUnmodifiableList());
    }

    private Port buildAdminPortOrNull() {
        if (this.adminPort == 0) {
            return null;
        }
        Port.Security secure = Objects.isNull(this.statusPageUrl) || this.statusPageUrl.startsWith("https") ? Port.Security.SECURE : Port.Security.NOT_SECURE;
        return Port.of(this.adminPort, Port.PortType.ADMIN, secure);
    }

    private Port buildApplicationPortOrNull(Map<String, Object> portDef, Port.Security secure) {
        if (!this.isEnabled(portDef.get("@enabled"))) {
            return null;
        }
        int portNumber = (Integer)portDef.get("$");
        return Port.of(portNumber, Port.PortType.APPLICATION, secure);
    }

    private boolean isEnabled(Object enabledFlag) {
        if (enabledFlag instanceof String) {
            return Boolean.parseBoolean((String)enabledFlag);
        }
        return (Boolean)enabledFlag;
    }

    private ServicePaths buildPaths() {
        return ServicePaths.builder().homePagePath(this.extractPathOrDefault(this.homePageUrl, "")).statusPath(this.extractPathOrDefault(this.statusPageUrl, "/ping")).healthCheckPath(this.extractPathOrDefault(this.healthCheckUrl, "/healthcheck")).build();
    }

    private String extractPathOrDefault(String url, String defaultPath) {
        try {
            return new URL(url).getPath();
        }
        catch (MalformedURLException e) {
            return defaultPath;
        }
    }

    @ConstructorProperties(value={"app", "status", "dataCenterInfo", "leaseInfo", "hostName", "ipAddr", "vipAddress", "secureVipAddress", "port", "securePort", "adminPort", "homePageUrl", "statusPageUrl", "healthCheckUrl", "metadata"})
    @Generated
    EurekaInstance(String app, String status, Map<String, String> dataCenterInfo, Map<String, Object> leaseInfo, String hostName, String ipAddr, String vipAddress, String secureVipAddress, Map<String, Object> port, Map<String, Object> securePort, int adminPort, String homePageUrl, String statusPageUrl, String healthCheckUrl, Map<String, String> metadata) {
        this.app = app;
        this.status = status;
        this.dataCenterInfo = dataCenterInfo;
        this.leaseInfo = leaseInfo;
        this.hostName = hostName;
        this.ipAddr = ipAddr;
        this.vipAddress = vipAddress;
        this.secureVipAddress = secureVipAddress;
        this.port = port;
        this.securePort = securePort;
        this.adminPort = adminPort;
        this.homePageUrl = homePageUrl;
        this.statusPageUrl = statusPageUrl;
        this.healthCheckUrl = healthCheckUrl;
        this.metadata = metadata;
    }

    @Generated
    public static EurekaInstanceBuilder builder() {
        return new EurekaInstanceBuilder();
    }

    @Generated
    public String getApp() {
        return this.app;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public Map<String, String> getDataCenterInfo() {
        return this.dataCenterInfo;
    }

    @Generated
    public Map<String, Object> getLeaseInfo() {
        return this.leaseInfo;
    }

    @Generated
    public String getHostName() {
        return this.hostName;
    }

    @Generated
    public String getIpAddr() {
        return this.ipAddr;
    }

    @Generated
    public String getVipAddress() {
        return this.vipAddress;
    }

    @Generated
    public String getSecureVipAddress() {
        return this.secureVipAddress;
    }

    @Generated
    public Map<String, Object> getPort() {
        return this.port;
    }

    @Generated
    public Map<String, Object> getSecurePort() {
        return this.securePort;
    }

    @Generated
    public int getAdminPort() {
        return this.adminPort;
    }

    @Generated
    public String getHomePageUrl() {
        return this.homePageUrl;
    }

    @Generated
    public String getStatusPageUrl() {
        return this.statusPageUrl;
    }

    @Generated
    public String getHealthCheckUrl() {
        return this.healthCheckUrl;
    }

    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EurekaInstance)) {
            return false;
        }
        EurekaInstance other = (EurekaInstance)o;
        if (this.getAdminPort() != other.getAdminPort()) {
            return false;
        }
        String this$app = this.getApp();
        String other$app = other.getApp();
        if (this$app == null ? other$app != null : !this$app.equals(other$app)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        Map<String, String> this$dataCenterInfo = this.getDataCenterInfo();
        Map<String, String> other$dataCenterInfo = other.getDataCenterInfo();
        if (this$dataCenterInfo == null ? other$dataCenterInfo != null : !((Object)this$dataCenterInfo).equals(other$dataCenterInfo)) {
            return false;
        }
        Map<String, Object> this$leaseInfo = this.getLeaseInfo();
        Map<String, Object> other$leaseInfo = other.getLeaseInfo();
        if (this$leaseInfo == null ? other$leaseInfo != null : !((Object)this$leaseInfo).equals(other$leaseInfo)) {
            return false;
        }
        String this$hostName = this.getHostName();
        String other$hostName = other.getHostName();
        if (this$hostName == null ? other$hostName != null : !this$hostName.equals(other$hostName)) {
            return false;
        }
        String this$ipAddr = this.getIpAddr();
        String other$ipAddr = other.getIpAddr();
        if (this$ipAddr == null ? other$ipAddr != null : !this$ipAddr.equals(other$ipAddr)) {
            return false;
        }
        String this$vipAddress = this.getVipAddress();
        String other$vipAddress = other.getVipAddress();
        if (this$vipAddress == null ? other$vipAddress != null : !this$vipAddress.equals(other$vipAddress)) {
            return false;
        }
        String this$secureVipAddress = this.getSecureVipAddress();
        String other$secureVipAddress = other.getSecureVipAddress();
        if (this$secureVipAddress == null ? other$secureVipAddress != null : !this$secureVipAddress.equals(other$secureVipAddress)) {
            return false;
        }
        Map<String, Object> this$port = this.getPort();
        Map<String, Object> other$port = other.getPort();
        if (this$port == null ? other$port != null : !((Object)this$port).equals(other$port)) {
            return false;
        }
        Map<String, Object> this$securePort = this.getSecurePort();
        Map<String, Object> other$securePort = other.getSecurePort();
        if (this$securePort == null ? other$securePort != null : !((Object)this$securePort).equals(other$securePort)) {
            return false;
        }
        String this$homePageUrl = this.getHomePageUrl();
        String other$homePageUrl = other.getHomePageUrl();
        if (this$homePageUrl == null ? other$homePageUrl != null : !this$homePageUrl.equals(other$homePageUrl)) {
            return false;
        }
        String this$statusPageUrl = this.getStatusPageUrl();
        String other$statusPageUrl = other.getStatusPageUrl();
        if (this$statusPageUrl == null ? other$statusPageUrl != null : !this$statusPageUrl.equals(other$statusPageUrl)) {
            return false;
        }
        String this$healthCheckUrl = this.getHealthCheckUrl();
        String other$healthCheckUrl = other.getHealthCheckUrl();
        if (this$healthCheckUrl == null ? other$healthCheckUrl != null : !this$healthCheckUrl.equals(other$healthCheckUrl)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        return !(this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getAdminPort();
        String $app = this.getApp();
        result = result * 59 + ($app == null ? 43 : $app.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        Map<String, String> $dataCenterInfo = this.getDataCenterInfo();
        result = result * 59 + ($dataCenterInfo == null ? 43 : ((Object)$dataCenterInfo).hashCode());
        Map<String, Object> $leaseInfo = this.getLeaseInfo();
        result = result * 59 + ($leaseInfo == null ? 43 : ((Object)$leaseInfo).hashCode());
        String $hostName = this.getHostName();
        result = result * 59 + ($hostName == null ? 43 : $hostName.hashCode());
        String $ipAddr = this.getIpAddr();
        result = result * 59 + ($ipAddr == null ? 43 : $ipAddr.hashCode());
        String $vipAddress = this.getVipAddress();
        result = result * 59 + ($vipAddress == null ? 43 : $vipAddress.hashCode());
        String $secureVipAddress = this.getSecureVipAddress();
        result = result * 59 + ($secureVipAddress == null ? 43 : $secureVipAddress.hashCode());
        Map<String, Object> $port = this.getPort();
        result = result * 59 + ($port == null ? 43 : ((Object)$port).hashCode());
        Map<String, Object> $securePort = this.getSecurePort();
        result = result * 59 + ($securePort == null ? 43 : ((Object)$securePort).hashCode());
        String $homePageUrl = this.getHomePageUrl();
        result = result * 59 + ($homePageUrl == null ? 43 : $homePageUrl.hashCode());
        String $statusPageUrl = this.getStatusPageUrl();
        result = result * 59 + ($statusPageUrl == null ? 43 : $statusPageUrl.hashCode());
        String $healthCheckUrl = this.getHealthCheckUrl();
        result = result * 59 + ($healthCheckUrl == null ? 43 : $healthCheckUrl.hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "EurekaInstance(app=" + this.getApp() + ", status=" + this.getStatus() + ", dataCenterInfo=" + this.getDataCenterInfo() + ", leaseInfo=" + this.getLeaseInfo() + ", hostName=" + this.getHostName() + ", ipAddr=" + this.getIpAddr() + ", vipAddress=" + this.getVipAddress() + ", secureVipAddress=" + this.getSecureVipAddress() + ", port=" + this.getPort() + ", securePort=" + this.getSecurePort() + ", adminPort=" + this.getAdminPort() + ", homePageUrl=" + this.getHomePageUrl() + ", statusPageUrl=" + this.getStatusPageUrl() + ", healthCheckUrl=" + this.getHealthCheckUrl() + ", metadata=" + this.getMetadata() + ")";
    }

    @Generated
    public EurekaInstance withApp(String app) {
        return this.app == app ? this : new EurekaInstance(app, this.status, this.dataCenterInfo, this.leaseInfo, this.hostName, this.ipAddr, this.vipAddress, this.secureVipAddress, this.port, this.securePort, this.adminPort, this.homePageUrl, this.statusPageUrl, this.healthCheckUrl, this.metadata);
    }

    @Generated
    public EurekaInstance withStatus(String status) {
        return this.status == status ? this : new EurekaInstance(this.app, status, this.dataCenterInfo, this.leaseInfo, this.hostName, this.ipAddr, this.vipAddress, this.secureVipAddress, this.port, this.securePort, this.adminPort, this.homePageUrl, this.statusPageUrl, this.healthCheckUrl, this.metadata);
    }

    @Generated
    public EurekaInstance withDataCenterInfo(Map<String, String> dataCenterInfo) {
        return this.dataCenterInfo == dataCenterInfo ? this : new EurekaInstance(this.app, this.status, dataCenterInfo, this.leaseInfo, this.hostName, this.ipAddr, this.vipAddress, this.secureVipAddress, this.port, this.securePort, this.adminPort, this.homePageUrl, this.statusPageUrl, this.healthCheckUrl, this.metadata);
    }

    @Generated
    public EurekaInstance withLeaseInfo(Map<String, Object> leaseInfo) {
        return this.leaseInfo == leaseInfo ? this : new EurekaInstance(this.app, this.status, this.dataCenterInfo, leaseInfo, this.hostName, this.ipAddr, this.vipAddress, this.secureVipAddress, this.port, this.securePort, this.adminPort, this.homePageUrl, this.statusPageUrl, this.healthCheckUrl, this.metadata);
    }

    @Generated
    public static class EurekaInstanceBuilder {
        @Generated
        private String app;
        @Generated
        private String status;
        @Generated
        private Map<String, String> dataCenterInfo;
        @Generated
        private Map<String, Object> leaseInfo;
        @Generated
        private String hostName;
        @Generated
        private String ipAddr;
        @Generated
        private String vipAddress;
        @Generated
        private String secureVipAddress;
        @Generated
        private Map<String, Object> port;
        @Generated
        private Map<String, Object> securePort;
        @Generated
        private int adminPort;
        @Generated
        private String homePageUrl;
        @Generated
        private String statusPageUrl;
        @Generated
        private String healthCheckUrl;
        @Generated
        private Map<String, String> metadata;

        @Generated
        EurekaInstanceBuilder() {
        }

        @Generated
        public EurekaInstanceBuilder app(String app) {
            this.app = app;
            return this;
        }

        @Generated
        public EurekaInstanceBuilder status(String status) {
            this.status = status;
            return this;
        }

        @Generated
        public EurekaInstanceBuilder dataCenterInfo(Map<String, String> dataCenterInfo) {
            this.dataCenterInfo = dataCenterInfo;
            return this;
        }

        @Generated
        public EurekaInstanceBuilder leaseInfo(Map<String, Object> leaseInfo) {
            this.leaseInfo = leaseInfo;
            return this;
        }

        @Generated
        public EurekaInstanceBuilder hostName(String hostName) {
            this.hostName = hostName;
            return this;
        }

        @Generated
        public EurekaInstanceBuilder ipAddr(String ipAddr) {
            this.ipAddr = ipAddr;
            return this;
        }

        @Generated
        public EurekaInstanceBuilder vipAddress(String vipAddress) {
            this.vipAddress = vipAddress;
            return this;
        }

        @Generated
        public EurekaInstanceBuilder secureVipAddress(String secureVipAddress) {
            this.secureVipAddress = secureVipAddress;
            return this;
        }

        @Generated
        public EurekaInstanceBuilder port(Map<String, Object> port) {
            this.port = port;
            return this;
        }

        @Generated
        public EurekaInstanceBuilder securePort(Map<String, Object> securePort) {
            this.securePort = securePort;
            return this;
        }

        @Generated
        public EurekaInstanceBuilder adminPort(int adminPort) {
            this.adminPort = adminPort;
            return this;
        }

        @Generated
        public EurekaInstanceBuilder homePageUrl(String homePageUrl) {
            this.homePageUrl = homePageUrl;
            return this;
        }

        @Generated
        public EurekaInstanceBuilder statusPageUrl(String statusPageUrl) {
            this.statusPageUrl = statusPageUrl;
            return this;
        }

        @Generated
        public EurekaInstanceBuilder healthCheckUrl(String healthCheckUrl) {
            this.healthCheckUrl = healthCheckUrl;
            return this;
        }

        @Generated
        public EurekaInstanceBuilder metadata(Map<String, String> metadata) {
            this.metadata = metadata;
            return this;
        }

        @Generated
        public EurekaInstance build() {
            return new EurekaInstance(this.app, this.status, this.dataCenterInfo, this.leaseInfo, this.hostName, this.ipAddr, this.vipAddress, this.secureVipAddress, this.port, this.securePort, this.adminPort, this.homePageUrl, this.statusPageUrl, this.healthCheckUrl, this.metadata);
        }

        @Generated
        public String toString() {
            return "EurekaInstance.EurekaInstanceBuilder(app=" + this.app + ", status=" + this.status + ", dataCenterInfo=" + this.dataCenterInfo + ", leaseInfo=" + this.leaseInfo + ", hostName=" + this.hostName + ", ipAddr=" + this.ipAddr + ", vipAddress=" + this.vipAddress + ", secureVipAddress=" + this.secureVipAddress + ", port=" + this.port + ", securePort=" + this.securePort + ", adminPort=" + this.adminPort + ", homePageUrl=" + this.homePageUrl + ", statusPageUrl=" + this.statusPageUrl + ", healthCheckUrl=" + this.healthCheckUrl + ", metadata=" + this.metadata + ")";
        }
    }
}

