/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.registry.consul.server;

import com.google.common.annotations.VisibleForTesting;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.kiwiproject.base.DefaultEnvironment;
import org.kiwiproject.base.KiwiEnvironment;
import org.kiwiproject.base.KiwiPreconditions;
import org.kiwiproject.registry.config.ServiceInfo;
import org.kiwiproject.registry.model.Port;
import org.kiwiproject.registry.model.ServiceInstance;
import org.kiwiproject.registry.model.ServicePaths;
import org.kiwiproject.registry.util.Ports;

public final class ConsulHelpers {
    public static Map<String, String> newDefaultMetadata(ServiceInfo serviceInfo) {
        return ConsulHelpers.newDefaultMetadata(ServiceInstance.fromServiceInfo(serviceInfo), (KiwiEnvironment)new DefaultEnvironment());
    }

    @VisibleForTesting
    static Map<String, String> newDefaultMetadata(ServiceInfo serviceInfo, KiwiEnvironment kiwiEnvironment) {
        return ConsulHelpers.newDefaultMetadata(ServiceInstance.fromServiceInfo(serviceInfo), kiwiEnvironment);
    }

    public static Map<String, String> newDefaultMetadata(ServiceInstance serviceInstance) {
        return ConsulHelpers.newDefaultMetadata(serviceInstance, (KiwiEnvironment)new DefaultEnvironment());
    }

    @VisibleForTesting
    static Map<String, String> newDefaultMetadata(ServiceInstance serviceInstance, KiwiEnvironment kiwiEnvironment) {
        KiwiPreconditions.checkArgumentNotNull((Object)serviceInstance);
        HashMap<String, String> metadata = new HashMap<String, String>();
        List<Port> ports = serviceInstance.getPorts();
        metadata.put("scheme", Ports.findFirstPortPreferSecure(ports, Port.PortType.APPLICATION).getScheme());
        metadata.put("adminPort", String.valueOf(Ports.findFirstPortPreferSecure(ports, Port.PortType.ADMIN).getNumber()));
        metadata.put("serviceUpTimestamp", String.valueOf(kiwiEnvironment.currentTimeMillis()));
        ServicePaths paths = serviceInstance.getPaths();
        metadata.put("homePagePath", paths.getHomePagePath());
        metadata.put("statusPath", paths.getStatusPath());
        metadata.put("healthCheckPath", paths.getHealthCheckPath());
        metadata.put("commitRef", serviceInstance.getCommitRef());
        metadata.put("description", serviceInstance.getDescription());
        metadata.put("version", serviceInstance.getVersion());
        metadata.put("ipAddress", serviceInstance.getIp());
        return metadata;
    }

    @Generated
    private ConsulHelpers() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

