/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.registry.management;

import lombok.Generated;
import org.kiwiproject.registry.config.ServiceInfo;
import org.kiwiproject.registry.model.ServiceInstance;
import org.kiwiproject.registry.server.RegistryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegistrationManager {
    @Generated
    private static final Logger LOG = LoggerFactory.getLogger(RegistrationManager.class);
    private final ServiceInfo serviceInfo;
    private final RegistryService registryService;

    public RegistrationManager(ServiceInfo serviceInfo, RegistryService registryService) {
        this.serviceInfo = serviceInfo;
        this.registryService = registryService;
    }

    public void start() {
        ServiceInstance candidate = this.registryService.createCandidateFrom(this.serviceInfo);
        LOG.info("Registering service as serviceName [{}] on host [{}] at ports [{}]", new Object[]{candidate.getServiceName(), candidate.getHostName(), candidate.getPorts()});
        this.registryService.register(candidate);
        LOG.info("Service registration sent");
        this.registryService.updateStatus(ServiceInstance.Status.UP);
    }

    public void stop() {
        LOG.info("Unregistering service");
        this.registryService.unregister();
        LOG.info("Service de-registration sent");
    }

    @Generated
    public ServiceInfo getServiceInfo() {
        return this.serviceInfo;
    }
}

