/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.registry.management.dropwizard;

import io.dropwizard.lifecycle.PortDescriptor;
import io.dropwizard.lifecycle.ServerLifecycleListener;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.component.LifeCycle;
import org.kiwiproject.base.KiwiPreconditions;
import org.kiwiproject.registry.config.ServiceInfo;
import org.kiwiproject.registry.management.RegistrationManager;
import org.kiwiproject.registry.model.Port;
import org.kiwiproject.registry.server.RegistryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegistrationLifecycleListener
extends AbstractLifeCycle.AbstractLifeCycleListener
implements ServerLifecycleListener {
    @Generated
    private static final Logger LOG = LoggerFactory.getLogger(RegistrationLifecycleListener.class);
    private final RegistrationManager registrationManager;

    public RegistrationLifecycleListener(RegistrationManager registrationManager) {
        this.registrationManager = registrationManager;
    }

    public RegistrationLifecycleListener(ServiceInfo serviceInfo, RegistryService registryService) {
        this.registrationManager = new RegistrationManager(serviceInfo, registryService);
    }

    public void serverStarted(Server server) {
        ServiceInfo serviceInfo = this.registrationManager.getServiceInfo();
        List<Port> ports = serviceInfo.getPorts();
        this.setPortsIfEmpty(ports, server);
        this.registrationManager.start();
    }

    private void setPortsIfEmpty(List<Port> ports, Server server) {
        KiwiPreconditions.checkArgumentNotNull(ports, (String)"ports in ServiceInfo must not be null");
        if (ports.isEmpty()) {
            int port = this.getLocalPort(server);
            int adminPort = this.getAdminPort(server);
            List descriptors = this.getPortDescriptorList(server);
            this.findPort(port, Port.PortType.APPLICATION, descriptors).ifPresent(ports::add);
            this.findPort(adminPort, Port.PortType.ADMIN, descriptors).ifPresent(ports::add);
        }
    }

    private Optional<Port> findPort(int port, Port.PortType portType, List<PortDescriptor> descriptors) {
        Optional<String> portProtocol = descriptors.stream().filter(descriptor -> descriptor.getPort() == port).map(PortDescriptor::getProtocol).findFirst();
        return portProtocol.map(protocol -> Port.of(port, portType, Port.Security.fromScheme(protocol)));
    }

    public void lifeCycleStopping(LifeCycle event) {
        try {
            this.registrationManager.stop();
        }
        catch (Exception e) {
            LOG.error("Service could not be de-registered It will need to expire or be manually de-registered.", (Throwable)e);
        }
    }
}

