/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.registry.eureka.client;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.kiwiproject.base.KiwiObjects;
import org.kiwiproject.base.KiwiPreconditions;
import org.kiwiproject.net.KiwiInternetAddresses;
import org.kiwiproject.registry.eureka.common.EurekaInstance;

final class EurekaParser {
    public static List<EurekaInstance> parseEurekaResponse(Map<String, Object> response) {
        KiwiPreconditions.checkArgumentNotNull(response, (String)"Eureka response map cannot be null");
        Map applications = (Map)response.get("applications");
        Preconditions.checkState((boolean)Objects.nonNull(applications), (Object)"Eureka data must contain a key 'applications' that contains a Map<String, Object>");
        Object applicationOrApplicationList = applications.get("application");
        ArrayList<EurekaInstance> eurekaInstances = new ArrayList<EurekaInstance>();
        if (Objects.nonNull(applicationOrApplicationList)) {
            if (applicationOrApplicationList instanceof List) {
                for (Map application : (List)applicationOrApplicationList) {
                    Object instances = application.get("instance");
                    eurekaInstances.addAll(EurekaParser.parseInstances(instances));
                }
            } else {
                eurekaInstances.addAll(EurekaParser.parseInstances(((Map)applicationOrApplicationList).get("instance")));
            }
        }
        return eurekaInstances;
    }

    private static List<EurekaInstance> parseInstances(Object instanceOrInstanceList) {
        KiwiPreconditions.checkArgumentNotNull((Object)instanceOrInstanceList, (String)"Instance data from Eureka can not be null");
        if (instanceOrInstanceList instanceof List) {
            List instanceList = (List)instanceOrInstanceList;
            return instanceList.stream().map(EurekaParser::buildInstance).collect(Collectors.toList());
        }
        Map instance = (Map)instanceOrInstanceList;
        return Lists.newArrayList((Object[])new EurekaInstance[]{EurekaParser.buildInstance(instance)});
    }

    private static EurekaInstance buildInstance(Map<String, Object> instanceData) {
        Map portMap = (Map)instanceData.get("port");
        Map securePortMap = (Map)instanceData.get("securePort");
        Map metadataMap = (Map)instanceData.get("metadata");
        Map leaseInfoMap = (Map)instanceData.get("leaseInfo");
        Map<String, Object> leaseInfo = EurekaParser.extractLeaseInfo(leaseInfoMap);
        String statusUrl = EurekaParser.getStringOrNull(instanceData, "statusUrl");
        String healthCheckUrl = EurekaParser.getStringOrNull(instanceData, "healthCheckUrl");
        String url = (String)KiwiObjects.firstNonNullOrNull((Object)statusUrl, (Object)healthCheckUrl, (Object[])new String[0]);
        int adminPort = EurekaParser.getAdminPort(url);
        return EurekaInstance.builder().vipAddress(EurekaParser.getStringOrNull(instanceData, "vipAddress")).secureVipAddress(EurekaParser.getStringOrNull(instanceData, "vipAddress")).app(EurekaParser.getStringOrNull(instanceData, "app")).hostName(EurekaParser.getStringOrNull(instanceData, "hostName")).ipAddr(EurekaParser.getStringOrNull(instanceData, "ipAddr")).status(EurekaParser.getStringOrNull(instanceData, "status")).homePageUrl(EurekaParser.getStringOrNull(instanceData, "homePageUrl")).healthCheckUrl(healthCheckUrl).statusPageUrl(statusUrl).port(portMap).securePort(securePortMap).adminPort(adminPort).leaseInfo(leaseInfo).metadata(metadataMap).rawResponse(instanceData).build();
    }

    private static Map<String, Object> extractLeaseInfo(Map<String, Object> leaseInfoMap) {
        if (Objects.nonNull(leaseInfoMap)) {
            return Map.of("renewalIntervalInSecs", leaseInfoMap.getOrDefault("renewalIntervalInSecs", 0), "durationInSecs", leaseInfoMap.getOrDefault("durationInSecs", 0), "registrationTimestamp", leaseInfoMap.getOrDefault("registrationTimestamp", 0L), "lastRenewalTimestamp", leaseInfoMap.getOrDefault("lastRenewalTimestamp", 0L), "evictionTimestamp", leaseInfoMap.getOrDefault("evictionTimestamp", 0L), "serviceUpTimestamp", leaseInfoMap.getOrDefault("serviceUpTimestamp", 0L));
        }
        return Map.of();
    }

    private static <K> String getStringOrNull(Map<? super K, ?> map, K key) {
        Object value = map.getOrDefault(key, null);
        Verify.verify((Objects.isNull(value) || value instanceof String ? 1 : 0) != 0, (String)"Value from Map must be a string or null", (Object[])new Object[0]);
        return value;
    }

    @VisibleForTesting
    static int getAdminPort(@Nullable String url) {
        if (StringUtils.isBlank((CharSequence)url)) {
            return 0;
        }
        return KiwiInternetAddresses.portFrom((String)url).orElseGet(() -> EurekaParser.defaultPortForScheme(url));
    }

    private static int defaultPortForScheme(String url) {
        return url.startsWith("https") ? 443 : 80;
    }

    @Generated
    private EurekaParser() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

