/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.registry.model;

import java.beans.ConstructorProperties;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.kiwiproject.registry.config.ServiceInfo;
import org.kiwiproject.registry.model.Port;
import org.kiwiproject.registry.model.ServicePaths;

public class ServiceInstance {
    private final String instanceId;
    private final Status status;
    private final String serviceName;
    private final String hostName;
    private final String ip;
    private final List<Port> ports;
    private final ServicePaths paths;
    private final String commitRef;
    private final String description;
    private final String version;
    private final Instant upSince;
    private final Map<String, String> metadata;
    private final Map<String, Object> nativeRegistryData;

    public static ServiceInstance fromServiceInfo(ServiceInfo serviceInfo) {
        return ServiceInstance.builder().serviceName(serviceInfo.getName()).hostName(serviceInfo.getHostname()).ip(serviceInfo.getIp()).ports(serviceInfo.getPorts()).paths(serviceInfo.getPaths()).commitRef(serviceInfo.getCommitRef()).description(serviceInfo.getDescription()).version(serviceInfo.getVersion()).metadata(Map.copyOf(serviceInfo.getMetadata())).build();
    }

    public Instant getUpSince() {
        return Objects.isNull(this.upSince) ? Instant.EPOCH : this.upSince;
    }

    public long getUpSinceMillis() {
        return this.getUpSince().toEpochMilli();
    }

    @ConstructorProperties(value={"instanceId", "status", "serviceName", "hostName", "ip", "ports", "paths", "commitRef", "description", "version", "upSince", "metadata", "nativeRegistryData"})
    @Generated
    ServiceInstance(String instanceId, Status status, String serviceName, String hostName, String ip, List<Port> ports, ServicePaths paths, String commitRef, String description, String version, Instant upSince, Map<String, String> metadata, Map<String, Object> nativeRegistryData) {
        this.instanceId = instanceId;
        this.status = status;
        this.serviceName = serviceName;
        this.hostName = hostName;
        this.ip = ip;
        this.ports = ports;
        this.paths = paths;
        this.commitRef = commitRef;
        this.description = description;
        this.version = version;
        this.upSince = upSince;
        this.metadata = metadata;
        this.nativeRegistryData = nativeRegistryData;
    }

    @Generated
    public static ServiceInstanceBuilder builder() {
        return new ServiceInstanceBuilder();
    }

    @Generated
    public ServiceInstanceBuilder toBuilder() {
        return new ServiceInstanceBuilder().instanceId(this.instanceId).status(this.status).serviceName(this.serviceName).hostName(this.hostName).ip(this.ip).ports(this.ports).paths(this.paths).commitRef(this.commitRef).description(this.description).version(this.version).upSince(this.upSince).metadata(this.metadata).nativeRegistryData(this.nativeRegistryData);
    }

    @Generated
    public String getInstanceId() {
        return this.instanceId;
    }

    @Generated
    public Status getStatus() {
        return this.status;
    }

    @Generated
    public String getServiceName() {
        return this.serviceName;
    }

    @Generated
    public String getHostName() {
        return this.hostName;
    }

    @Generated
    public String getIp() {
        return this.ip;
    }

    @Generated
    public List<Port> getPorts() {
        return this.ports;
    }

    @Generated
    public ServicePaths getPaths() {
        return this.paths;
    }

    @Generated
    public String getCommitRef() {
        return this.commitRef;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @Generated
    public Map<String, Object> getNativeRegistryData() {
        return this.nativeRegistryData;
    }

    @Generated
    public ServiceInstance withInstanceId(String instanceId) {
        return this.instanceId == instanceId ? this : new ServiceInstance(instanceId, this.status, this.serviceName, this.hostName, this.ip, this.ports, this.paths, this.commitRef, this.description, this.version, this.upSince, this.metadata, this.nativeRegistryData);
    }

    @Generated
    public ServiceInstance withStatus(Status status) {
        return this.status == status ? this : new ServiceInstance(this.instanceId, status, this.serviceName, this.hostName, this.ip, this.ports, this.paths, this.commitRef, this.description, this.version, this.upSince, this.metadata, this.nativeRegistryData);
    }

    @Generated
    public ServiceInstance withMetadata(Map<String, String> metadata) {
        return this.metadata == metadata ? this : new ServiceInstance(this.instanceId, this.status, this.serviceName, this.hostName, this.ip, this.ports, this.paths, this.commitRef, this.description, this.version, this.upSince, metadata, this.nativeRegistryData);
    }

    @Generated
    public ServiceInstance withNativeRegistryData(Map<String, Object> nativeRegistryData) {
        return this.nativeRegistryData == nativeRegistryData ? this : new ServiceInstance(this.instanceId, this.status, this.serviceName, this.hostName, this.ip, this.ports, this.paths, this.commitRef, this.description, this.version, this.upSince, this.metadata, nativeRegistryData);
    }

    @Generated
    public static class ServiceInstanceBuilder {
        @Generated
        private String instanceId;
        @Generated
        private Status status;
        @Generated
        private String serviceName;
        @Generated
        private String hostName;
        @Generated
        private String ip;
        @Generated
        private List<Port> ports;
        @Generated
        private ServicePaths paths;
        @Generated
        private String commitRef;
        @Generated
        private String description;
        @Generated
        private String version;
        @Generated
        private Instant upSince;
        @Generated
        private Map<String, String> metadata;
        @Generated
        private Map<String, Object> nativeRegistryData;

        @Generated
        ServiceInstanceBuilder() {
        }

        @Generated
        public ServiceInstanceBuilder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        @Generated
        public ServiceInstanceBuilder status(Status status) {
            this.status = status;
            return this;
        }

        @Generated
        public ServiceInstanceBuilder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        @Generated
        public ServiceInstanceBuilder hostName(String hostName) {
            this.hostName = hostName;
            return this;
        }

        @Generated
        public ServiceInstanceBuilder ip(String ip) {
            this.ip = ip;
            return this;
        }

        @Generated
        public ServiceInstanceBuilder ports(List<Port> ports) {
            this.ports = ports;
            return this;
        }

        @Generated
        public ServiceInstanceBuilder paths(ServicePaths paths) {
            this.paths = paths;
            return this;
        }

        @Generated
        public ServiceInstanceBuilder commitRef(String commitRef) {
            this.commitRef = commitRef;
            return this;
        }

        @Generated
        public ServiceInstanceBuilder description(String description) {
            this.description = description;
            return this;
        }

        @Generated
        public ServiceInstanceBuilder version(String version) {
            this.version = version;
            return this;
        }

        @Generated
        public ServiceInstanceBuilder upSince(Instant upSince) {
            this.upSince = upSince;
            return this;
        }

        @Generated
        public ServiceInstanceBuilder metadata(Map<String, String> metadata) {
            this.metadata = metadata;
            return this;
        }

        @Generated
        public ServiceInstanceBuilder nativeRegistryData(Map<String, Object> nativeRegistryData) {
            this.nativeRegistryData = nativeRegistryData;
            return this;
        }

        @Generated
        public ServiceInstance build() {
            return new ServiceInstance(this.instanceId, this.status, this.serviceName, this.hostName, this.ip, this.ports, this.paths, this.commitRef, this.description, this.version, this.upSince, this.metadata, this.nativeRegistryData);
        }

        @Generated
        public String toString() {
            return "ServiceInstance.ServiceInstanceBuilder(instanceId=" + this.instanceId + ", status=" + this.status + ", serviceName=" + this.serviceName + ", hostName=" + this.hostName + ", ip=" + this.ip + ", ports=" + this.ports + ", paths=" + this.paths + ", commitRef=" + this.commitRef + ", description=" + this.description + ", version=" + this.version + ", upSince=" + this.upSince + ", metadata=" + this.metadata + ", nativeRegistryData=" + this.nativeRegistryData + ")";
        }
    }

    public static enum Status {
        UP,
        DOWN,
        STARTING;

    }
}

