/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.registry.model;

import java.beans.ConstructorProperties;
import java.util.Objects;
import javax.annotation.Nullable;
import lombok.Generated;
import org.kiwiproject.base.KiwiPreconditions;

public class Port {
    private final int number;
    private final PortType type;
    private final Security secure;

    public static Port of(int number, @Nullable PortType portType, @Nullable Security security) {
        KiwiPreconditions.checkValidPort((int)number);
        PortType nonNullPortType = Objects.isNull((Object)portType) ? PortType.APPLICATION : portType;
        Security nonNullSecurity = Objects.isNull((Object)security) ? Security.SECURE : security;
        return Port.builder().number(number).type(nonNullPortType).secure(nonNullSecurity).build();
    }

    public boolean isSecure() {
        return this.secure == Security.SECURE;
    }

    public String getScheme() {
        return this.secure.getScheme();
    }

    public boolean isApplication() {
        return this.type == PortType.APPLICATION;
    }

    public boolean isAdmin() {
        return this.type == PortType.ADMIN;
    }

    @ConstructorProperties(value={"number", "type", "secure"})
    @Generated
    Port(int number, PortType type, Security secure) {
        this.number = number;
        this.type = type;
        this.secure = secure;
    }

    @Generated
    public static PortBuilder builder() {
        return new PortBuilder();
    }

    @Generated
    public int getNumber() {
        return this.number;
    }

    @Generated
    public PortType getType() {
        return this.type;
    }

    @Generated
    public Security getSecure() {
        return this.secure;
    }

    @Generated
    public static class PortBuilder {
        @Generated
        private int number;
        @Generated
        private PortType type;
        @Generated
        private Security secure;

        @Generated
        PortBuilder() {
        }

        @Generated
        public PortBuilder number(int number) {
            this.number = number;
            return this;
        }

        @Generated
        public PortBuilder type(PortType type) {
            this.type = type;
            return this;
        }

        @Generated
        public PortBuilder secure(Security secure) {
            this.secure = secure;
            return this;
        }

        @Generated
        public Port build() {
            return new Port(this.number, this.type, this.secure);
        }

        @Generated
        public String toString() {
            return "Port.PortBuilder(number=" + this.number + ", type=" + this.type + ", secure=" + this.secure + ")";
        }
    }

    public static enum Security {
        SECURE("https"),
        NOT_SECURE("http");

        private final String scheme;

        private Security(String scheme) {
            this.scheme = scheme;
        }

        public static Security fromScheme(String schemeToCheck) {
            return Security.NOT_SECURE.scheme.equalsIgnoreCase(schemeToCheck) ? NOT_SECURE : SECURE;
        }

        @Generated
        public String getScheme() {
            return this.scheme;
        }
    }

    public static enum PortType {
        APPLICATION,
        ADMIN;

    }
}

