/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.registry.eureka.config;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.List;
import javax.validation.constraints.NotBlank;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.kiwiproject.net.KiwiUrls;
import org.kiwiproject.registry.eureka.config.ListToCsvStringDeserializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EurekaConfig {
    @Generated
    private static final Logger LOG = LoggerFactory.getLogger(EurekaConfig.class);
    @JsonDeserialize(using=ListToCsvStringDeserializer.class)
    protected String registryUrls;
    private String domainOverride;
    private boolean includeNativeData;

    @NotBlank
    public String getRegistryUrls() {
        String adjustedUrls = StringUtils.isBlank((CharSequence)this.domainOverride) ? this.registryUrls : KiwiUrls.replaceDomainsIn((String)this.registryUrls, (String)this.domainOverride);
        this.logWarningIfDomainOverrideIsSet();
        return adjustedUrls;
    }

    public void setRegistryUrls(String urlCsv) {
        this.registryUrls = urlCsv;
    }

    public void setRegistryUrls(List<String> urls) {
        this.registryUrls = String.join((CharSequence)",", urls);
    }

    private void logWarningIfDomainOverrideIsSet() {
        if (StringUtils.isNotBlank((CharSequence)this.domainOverride)) {
            LOG.warn("The 'domainOverride' parameter supersedes 'registryUrls'. Both are currently set in YAML config");
        }
    }

    @Generated
    public String getDomainOverride() {
        return this.domainOverride;
    }

    @Generated
    public boolean isIncludeNativeData() {
        return this.includeNativeData;
    }

    @Generated
    public void setDomainOverride(String domainOverride) {
        this.domainOverride = domainOverride;
    }

    @Generated
    public void setIncludeNativeData(boolean includeNativeData) {
        this.includeNativeData = includeNativeData;
    }
}

